package com.paypal.hybris.core.exception;

import com.paypal.http.exceptions.HttpException;
import de.hybris.platform.payment.AdapterException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.Optional;

public class PayPalAdapterException extends AdapterException {

	private static final String DATE_PATTERN = "EEE, dd MMM yyyy HH:mm:ss zzz";
	private static final String PAYPAL_DEBUG_ID = "Paypal-Debug-Id";
	private static final String DATE = "Date";
	private final IOException parentException;
	private final String debugId;
	private final Date createDate;

	public PayPalAdapterException(IOException parentException) {
		super(parentException.getMessage());
		this.parentException = parentException;
		if (parentException instanceof HttpException e) {
			this.debugId = Optional.ofNullable(e.headers().header(PAYPAL_DEBUG_ID)).orElse(StringUtils.EMPTY);
			if (e.headers() == null || e.headers().header(DATE) == null) {
				this.createDate = new Date();
			} else {
				this.createDate = Optional.ofNullable(parseDate(e.headers().header(DATE))).orElse(new Date());
			}
		} else {
			this.debugId = StringUtils.EMPTY;
			this.createDate = new Date();
		}
	}

	protected Date parseDate(String createTime) {
		try {
			return DateUtils.parseDate(createTime, DATE_PATTERN);
		} catch (ParseException e) {
			return new Date();
		}
	}

	public IOException getParentException() {
		return parentException;
	}

	public String getDebugId() {
		return debugId;
	}

	public Date getCreateDate() {
		return createDate;
	}
}
