package com.paypal.hybris.core.exception;

public class InvalidPaymentInfoException extends Exception
{

    private final String paymentInfoId;

    /**
     * @param id
     */
    public InvalidPaymentInfoException(final String id)
    {
        super("PaymentInfo [" + id + "] is invalid for the current cart");
        this.paymentInfoId = id;
    }

    /**
     * @return the paymentInfoId
     */
    public String getPaymentInfoId()
    {
        return paymentInfoId;
    }

}

