package com.paypal.hybris.core.dao.impl;

import com.paypal.hybris.core.dao.PaymentTransactionsDao;
import de.hybris.platform.payment.model.PaymentTransactionEntryModel;
import de.hybris.platform.servicelayer.internal.dao.AbstractItemDao;
import de.hybris.platform.servicelayer.search.FlexibleSearchQuery;
import de.hybris.platform.servicelayer.search.SearchResult;

import java.util.Collections;


public class DefaultPaymentTransactionsDao extends AbstractItemDao implements PaymentTransactionsDao {

    private static final String TRANSACTION_ID = "transactionId";

    protected static final String GET_TRANSACTION_BY_ID =
        "SELECT {pk} FROM {" + PaymentTransactionEntryModel._TYPECODE + "} "
            + "WHERE {:" + PaymentTransactionEntryModel.REQUESTID + "} = ?transactionId";

    @Override
    public PaymentTransactionEntryModel getTransactionEntryById(final String transactionId) {
        final FlexibleSearchQuery fQuery = new FlexibleSearchQuery(GET_TRANSACTION_BY_ID);
        fQuery.addQueryParameter(TRANSACTION_ID, transactionId);
        fQuery.setResultClassList(Collections.singletonList(PaymentTransactionEntryModel.class));
        final SearchResult<PaymentTransactionEntryModel> searchResult = getFlexibleSearchService().search(fQuery);
        return searchResult.getResult().stream().findFirst().orElse(null);
    }
}
