package com.paypal.hybris.core.dao.impl;

import com.paypal.hybris.core.dao.PayPalLogoDao;
import de.hybris.platform.catalog.model.CatalogUnawareMediaModel;
import de.hybris.platform.servicelayer.exceptions.SystemException;
import de.hybris.platform.servicelayer.search.FlexibleSearchService;
import de.hybris.platform.servicelayer.search.FlexibleSearchQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Optional;

public class DefaultPayPalLogoDao implements PayPalLogoDao {

    private static final String CODE = "code";
    private static final String FIND_LOGO_QUERY = "SELECT {" + CatalogUnawareMediaModel.PK + "} FROM {"
            + CatalogUnawareMediaModel._TYPECODE + "} WHERE {" + CatalogUnawareMediaModel.CODE + "}=?code";

    private static final Logger LOG = LoggerFactory.getLogger(DefaultPayPalLogoDao.class);

    private FlexibleSearchService flexibleSearchService;

    @Override
    public Optional<CatalogUnawareMediaModel> findExistingLogo(final String logoCode) {
        final FlexibleSearchQuery fQuery = new FlexibleSearchQuery(FIND_LOGO_QUERY);
        fQuery.addQueryParameter(CODE, logoCode);

        try {
            return Optional.of(flexibleSearchService.searchUnique(fQuery));
        } catch (final SystemException e) {
            LOG.error("Fail find existing logo: %s".formatted(e.getMessage()));
            return Optional.empty();
        }
    }

    public void setFlexibleSearchService(FlexibleSearchService flexibleSearchService) {
        this.flexibleSearchService = flexibleSearchService;
    }

}
