/**
 *
 */
package com.paypal.hybris.core.dao.impl;

import com.paypal.hybris.core.dao.PayPalCustomerAccountDao;
import de.hybris.platform.catalog.model.CatalogUnawareMediaModel;
import de.hybris.platform.commerceservices.customer.dao.impl.DefaultCustomerAccountDao;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.servicelayer.exceptions.ModelNotFoundException;
import de.hybris.platform.servicelayer.exceptions.SystemException;
import de.hybris.platform.servicelayer.search.FlexibleSearchQuery;
import de.hybris.platform.servicelayer.search.SearchResult;
import de.hybris.platform.servicelayer.util.ServicesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class DefaultPayPalCustomerAccountDao extends DefaultCustomerAccountDao implements PayPalCustomerAccountDao {

    private static final Logger LOG = LoggerFactory.getLogger(DefaultPayPalCustomerAccountDao.class);

    private static final String PAYER_ID_MUST_NOT_BE_NULL = "Payer id must not be null";
    private static final String VAULT_ID = "vaultId";
    private static final String FIND_CUSTOMER_BY_VAULT_ID_QUERY = "SELECT {" + CustomerModel.PK + "} FROM {"
            + CustomerModel._TYPECODE + "} WHERE {" + CustomerModel.VAULTCUSTOMERID + "}=?vaultId";

    @Override
    public CustomerModel findCustomerByPayPalPayerId(String payerId) {
        ServicesUtil.validateParameterNotNull(payerId, PAYER_ID_MUST_NOT_BE_NULL);
        final Map queryParams = new HashMap();
        queryParams.put("payPalPayerId", payerId);

        final SearchResult result = getFlexibleSearchService().search(
            "SELECT {" + CustomerModel.PK + "} FROM {" + CustomerModel._TYPECODE + "} WHERE {"
                + CustomerModel.PAYPALPAYERID
                + "} = ?payPalPayerId", queryParams);
        return ((result.getCount() > 0) ? (CustomerModel) result.getResult().get(0) : null);
    }

    @Override
    public Optional<CustomerModel> findCustomerByVaultId(final String vaultId) {
        final FlexibleSearchQuery fQuery = new FlexibleSearchQuery(FIND_CUSTOMER_BY_VAULT_ID_QUERY);
        fQuery.addQueryParameter(VAULT_ID, vaultId);

        try {
            return Optional.of(getFlexibleSearchService().searchUnique(fQuery));
        } catch (ModelNotFoundException exception) {
            LOG.error(String.format("Customer with vaultId:%s not found.", vaultId));
            return Optional.empty();
        }
    }
}