package com.paypal.hybris.core.dao.impl;

import com.paypal.hybris.core.dao.PayPalCartDao;
import de.hybris.platform.commerceservices.order.dao.impl.DefaultCommerceCartDao;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.servicelayer.exceptions.ModelNotFoundException;
import de.hybris.platform.servicelayer.search.FlexibleSearchQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;


public class DefaultPayPalCartDao extends DefaultCommerceCartDao implements PayPalCartDao {

    private static final Logger LOG = LoggerFactory.getLogger(DefaultPayPalCartDao.class);

    private static final String PAYPAL_ORDER_ID = "payPalOrderId";

    private static final String GET_CART_BY_ORDER_ID_FOR_LOCAL_PAYMENTS =
        "SELECT {pk} FROM {" + CartModel._TYPECODE + " as cart} "
            + "WHERE {cart:" + CartModel.PAYPALORDERID + "} = ?payPalOrderId";

    @Override
    public Optional<CartModel> getCartByPayPalOrderIdForLocalPayments(String payPalOrderId) {
        Map<String, Object> params = new HashMap<>();
        params.put(PAYPAL_ORDER_ID, payPalOrderId);
        FlexibleSearchQuery searchQuery = createSearchQuery(GET_CART_BY_ORDER_ID_FOR_LOCAL_PAYMENTS, params,
                CartModel.class);

        try{
            return Optional.of(getFlexibleSearchService().searchUnique(searchQuery));
        } catch(ModelNotFoundException exception) {
            LOG.error("The CartModel by paypalOrderId = {} was not found", payPalOrderId);
        }

        return Optional.empty();
    }
}
