package com.paypal.hybris.core.dao.impl;

import com.paypal.hybris.core.dao.PayPalCarrierDao;
import com.paypal.hybris.core.model.PayPalCarrierModel;
import de.hybris.platform.servicelayer.search.FlexibleSearchQuery;
import de.hybris.platform.servicelayer.search.FlexibleSearchService;
import de.hybris.platform.servicelayer.search.SearchResult;

import java.util.List;
import java.util.Optional;

public class DefaultPayPalCarrierDao implements PayPalCarrierDao {

    private static final String GET_ALL_CARRIERS = "SELECT {pk} FROM {" + PayPalCarrierModel._TYPECODE + "} ";
    private FlexibleSearchService flexibleSearchService;

    @Override
    public Optional<List<PayPalCarrierModel>> getAllCarriers() {
        try {
            SearchResult<PayPalCarrierModel> searchResult = flexibleSearchService.search(new FlexibleSearchQuery(GET_ALL_CARRIERS));
            return Optional.of(searchResult.getResult());
        } catch (Exception e) {
            return Optional.empty();
        }
    }

    public void setFlexibleSearchService(FlexibleSearchService flexibleSearchService) {
        this.flexibleSearchService = flexibleSearchService;
    }

}
