/**
 *
 */
package com.paypal.hybris.core.dao;

import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import de.hybris.platform.core.servicelayer.data.SearchPageData;
import java.time.YearMonth;
import java.util.Optional;

public interface PayPalPaymentInfoDao {
    Optional<PayPalCreditCardPaymentInfoModel> findPaymentInfoByPayPalOrderId(String payPalOrderId);

    Optional<PayPalCreditCardPaymentInfoModel> findPaymentInfoByPK(String pk);

    void removePaymentInfoByPK(String pk);

    Optional<PayPalCreditCardPaymentInfoModel> findCardBySubscriptionId(String subscriptionId);

    SearchPageData<PayPalCreditCardPaymentInfoModel> findAllExpiredCards(
        SearchPageData<PayPalCreditCardPaymentInfoModel> searchPageData);

    SearchPageData<PayPalCreditCardPaymentInfoModel> findAllExpiredSoon(YearMonth expireSoonValue,
        SearchPageData<PayPalCreditCardPaymentInfoModel> searchPageData);
}
