/*
 * [y] hybris Platform
 *
 * Copyright (c) 2018 SAP SE or an SAP affiliate company. All rights reserved.
 *
 * This software is the confidential and proprietary information of SAP
 * ("Confidential Information"). You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms of the
 * license agreement you entered into with SAP.
 */
package com.paypal.hybris.core.constants;

/**
 * Global class for all Paypalcore constants. You can add global constants for your extension into this class.
 */
public final class PaypalcoreConstants extends GeneratedPaypalcoreConstants {

    public static final String EXTENSIONNAME = "paypalcore";
    public static final String PAYPAL_PROVIDER_NAME = "PayPal";

    public static final String PAYPAL_INTENT_AUTHORIZE = "authorize";
    public static final String PAYPAL_3_DS_VERIFICATION_DEFAULT_TYPE = "auto";
    public static final String PAYPAL_INTENT_CAPTURE = "capture";

    public static final String AUTHORIZATION_HEADER = "Authorization";

    public static final String PAYPAL_REQUEST_ID = "PayPal-Request-Id";

    public static final String PAYPAL_ORDER_ID_PLACEHOLDER = "ORDER_ID_PLACEHOLDER";
    public static final String PAYPAL_SUBSCRIPTION_ID_PLACEHOLDER = "SUBSCRIPTION_ID_PLACEHOLDER";
    public static final String PAYPAL_EXPRESS_BILLING_AGREEMENT_FLOW = "EXPRESS_BILLING_AGREEMENT_FLOW";
    public static final String PAYPAL_ORDER_PROCESS_FLOW = "ORDER_PROCESS_FLOW";
    public static final String PAYPAL_INTENT_CAPTURE_PROCESS_FLOW = "CAPTURE_INTENT_FLOW";
    public static final String PAYPAL_REPLENISHMENT_FLOW = "PAYPAL_REPLENISHMENT_FLOW";
    public static final String PAYPAL_VAULT_SAVED_FLOW = "VAULT_SAVED_FLOW";
    public static final String DEFAULT_FLOW = "DEFAULT_FLOW";
    public static final String PAYPAL_LIVE_ENVIRONMENT = "live";
    public static final String PAYPAL_HOSTED_FIELDS = "paypal_hosted_fields_card";
    public static final String CREATED_STATUS_RESULT = "CREATED";
    public static final String COMPLETED_STATUS_RESULT = "COMPLETED";
    public static final String SAVED_STATUS_RESULT = "SAVED";
    public static final String BILLING_AGREEMENT = "BILLING_AGREEMENT";

    public static final String GET_FROM_FILE = "GET_FROM_FILE";
    public static final String FIRST_PAYMENT = "FIRST_PAYMENT";
    public static final String ONE_TIME_PAYMENT = "ONE_TIME_PAYMENT";
    public static final String SAVED_PAYMENT = "SAVED_PAYMENT";
    public static final String REPLENISHMENT = "REPLENISHMENT";
    public static final String SET_PROVIDED_ADDRESS = "SET_PROVIDED_ADDRESS";
    public static final String NO_SHIPPING = "NO_SHIPPING";
    public static final String APPLE_PAY_REGION_FIELD_CODE = "administrativeArea";


    // Configuration properties
    public static final String CLIENT_ID = "paypal.client.id";
    public static final String SECRET_KEY = "paypal.secret.key";
    public static final String PAYPAL_ENV_CONFIGURATION = "paypal.environment.configuration.type";
    public static final String PAYPAL_API_URL = "paypal.api.url";
    public static final String PAYPAL_SDK_JS_URL = "paypal.sdk.js.url";
    public static final String PAYPAL_PARTNER_ATTRIBUTION_ID = "paypal.partner.attribution.id";
    public static final String PAYPAL_NONDECIMAL_CURRENCY = "paypal.nondecimal.currency";
    public static final String PAYPAL_CONNECT_SCRIPT = "paypal.connect.script";
    public static final String PAYPAL_CONNECT_SCOPES = "paypal.connect.scopes";
    public static final String PAYPAL_CONNECT_RESPONSE_TYPE = "paypal.connect.responseType";
    public static final String PAYPAL_CONNECT_RETURN_URL = "paypal.connect.returnUrl";
    public static final String PAYPAL_CONNECT_CHECKOUT_RETURN_URL = "paypal.connect.checkout.returnUrl";


    public static final String PAYPAL_CART_PAGE_TYPE = "cart";
    public static final String PAYPAL_BILLING_PAGE_TYPE = "billing";
    public static final String PAYPAL_ADD_TO_CART_POPUP_PAGE_TYPE = "add.to.cart.popup";
    public static final String PAYPAL_CART_POPUP_PAGE_TYPE = "cart.popup";
    public static final String PAYPAL_EMPTY_STRING = "";
    public static final String PAYPAL_COMMA = ",";
    public static final int PAYPAL_TEMP_PASSWORD_LENGTH = 20;
    public static final int NUMBER_OF_AVAILABLE_AUTHORIZATION_FOR_SAVED_ORDER = 3;
    public static final String PAYPAL_CHARACTERS_FOR_PASSWORD = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    public static final String PAYPAL_IMAGES_PREFIX = "paypal.image.";

    public static final String LPM_FUNDING_LIST = "bancontact,blik,boleto,eps,ideal,itau,maxima,mercadopago,"
        + "mybank,oxxo,p24,payu,sepa,trustly,wechatpay,zimpler";
    public static final String PAYPAL_CARD_FUNDING = "card";

    public static final String PLATFORM_LOGO_CODE = "paypalcorePlatformLogo";

    public static final String CHECKOUT_URL = "/v2/checkout/orders/";
    public static final String PAYPAL_CHECKOUT_PAYMENT_ERROR_MSG = "Something went wrong, please try again.";
    public static final String APPLE_PAY_INVALID_SHIPPING_CONTACT_ERROR_CODE = "shippingContactInvalid";

    private PaypalcoreConstants() {
        //empty to avoid instantiating this constant class
    }

    // implement here constants used by this extension


}
