package com.paypal.hybris.core.commands.impl;

import com.paypal.hybris.core.commands.PayPalAbstractCommand;
import com.paypal.hybris.core.constants.PaypalcoreConstants;
import com.paypal.hybris.data.PayPalSavePaymentForPurchaseLaterRequest;
import com.paypal.hybris.data.PayPalSetupTokenResponse;
import de.hybris.platform.payment.AdapterException;
import de.hybris.platform.payment.commands.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

import java.text.SimpleDateFormat;
import java.util.UUID;

public class DefaultPaypalCreatePaymentTokenCommand extends PayPalAbstractCommand
        implements Command<PayPalSavePaymentForPurchaseLaterRequest, PayPalSetupTokenResponse> {

    private static final Logger LOG = LoggerFactory.getLogger(DefaultPaypalCreatePaymentTokenCommand.class);
    private static final String  PAYMENT_TOKEN_URL = "https://api-m.sandbox.paypal.com/v3/vault/payment-tokens";
    private static final String DATE_FORMAT = "yyyy.MM.dd.HH.mm.ss";

    private RestTemplate restTemplate;

    @Override
    public PayPalSetupTokenResponse perform(PayPalSavePaymentForPurchaseLaterRequest payPalSavePaymentForPurchaseLaterRequest) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(PaypalcoreConstants.AUTHORIZATION_HEADER, createAPIContext().getAccessToken());
        headers.add(PaypalcoreConstants.PAYPAL_REQUEST_ID, new SimpleDateFormat(DATE_FORMAT)
                .format(System.currentTimeMillis()).concat(UUID.randomUUID().toString()));
        HttpEntity<PayPalSavePaymentForPurchaseLaterRequest> httpEntity
                = new HttpEntity<>(payPalSavePaymentForPurchaseLaterRequest, headers);
        ResponseEntity<PayPalSetupTokenResponse> response;
        try {
            response = restTemplate.postForEntity(PAYMENT_TOKEN_URL, httpEntity, PayPalSetupTokenResponse.class);
        } catch (HttpClientErrorException ex){
            LOG.error("Validation error from client side: ", ex);
            throw ex;
        } catch (Exception e) {
            LOG.error("Failed", e);
            throw new AdapterException(e.getMessage());
        }

        return response.getBody();
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

}
