package com.paypal.hybris.core.commands.impl;

import com.paypal.base.rest.JSONFormatter;
import com.paypal.core.PayPalEnvironment;
import com.paypal.hybris.core.commands.PayPalAbstractCommand;
import com.paypal.hybris.core.constants.PaypalcoreConstants;
import com.paypal.hybris.data.PayPalOrderResponseData;
import com.paypal.hybris.data.PayPalTrackingInfoData;
import com.paypal.hybris.data.PayPalTrackingInfoRequestData;
import de.hybris.platform.payment.AdapterException;
import de.hybris.platform.payment.commands.Command;
import org.apache.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import java.util.Objects;

public class DefaultPayPalSendTrackingInfoCommand extends PayPalAbstractCommand
        implements Command<PayPalTrackingInfoData, String> {

    private static final Logger LOG = Logger.getLogger(DefaultPayPalSendTrackingInfoCommand.class);
    private static final String TRACKING_URL = "/v2/checkout/orders/%s/track";
    private static final String TRACKING_INFO_REQUEST = "Tracking info request: \n";
    private RestTemplate restTemplate;

    @Override
    public String perform(final PayPalTrackingInfoData data) {
        final PayPalEnvironment payPalEnvironment = createPayPalEnvironment();
        final HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(PaypalcoreConstants.AUTHORIZATION_HEADER, createAPIContext().getAccessToken());

        final HttpEntity<PayPalTrackingInfoRequestData> httpEntity = new HttpEntity<>(data.getTrackingInfo(), headers);
        final String url = payPalEnvironment.baseUrl() + TRACKING_URL.formatted(data.getOrderId());
        final ResponseEntity<PayPalOrderResponseData> response;

        LOG.debug(TRACKING_INFO_REQUEST.concat(JSONFormatter.toJSON(httpEntity.getBody())));
        try {
            response = restTemplate.postForEntity(url, httpEntity, PayPalOrderResponseData.class);
        } catch (Exception e) {
            throw new AdapterException(e);
        }

        return Objects.requireNonNull(response.getBody()).getStatus();
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

}
