package com.paypal.hybris.core.commands.impl;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.CHECKOUT_URL;

import com.paypal.core.PayPalEnvironment;
import com.paypal.hybris.core.commands.PayPalAbstractCommand;
import com.paypal.hybris.core.constants.PaypalcoreConstants;
import com.paypal.hybris.data.PayPalSaveOrderResponseData;
import com.paypal.hybris.data.PurchaseUnitData;
import de.hybris.platform.payment.AdapterException;
import de.hybris.platform.payment.commands.Command;
import org.apache.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class DefaultPayPalSaveOrderCommand extends PayPalAbstractCommand  implements
    Command<String, String> {

    private static final String SAVE = "/save";
    private static final String SAVING_ORDER_ERROR_MESSAGE = "ERROR WHILE SAVING ORDER\nException: ";
    private static final String PURCHASE_UNIT_ERROR = "ERROR WHILE SAVING ORDER\nException: ";
    private static final Logger LOG = Logger.getLogger(DefaultPayPalSaveOrderCommand.class);
    private RestTemplate restTemplate;

    @Override
    public String perform(String subscriptionId) {
        PayPalEnvironment payPalEnvironment = createPayPalEnvironment();
        final HttpHeaders headers = new HttpHeaders();
        final String saveOrderUrl = payPalEnvironment.baseUrl() + CHECKOUT_URL + subscriptionId + SAVE;
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(PaypalcoreConstants.AUTHORIZATION_HEADER, createAPIContext().getAccessToken());
        final HttpEntity<MultiValueMap<String, String>> httpEntity = new HttpEntity<>(headers);
        final ResponseEntity<PayPalSaveOrderResponseData> response;
        final String purchaseUnitId;
        try {
            response = restTemplate.postForEntity(saveOrderUrl, httpEntity, PayPalSaveOrderResponseData.class);
            purchaseUnitId = translateResponse(response.getBody());
        } catch (Exception ex) {
            LOG.error(SAVING_ORDER_ERROR_MESSAGE, ex);
            throw new AdapterException(ex.getMessage());
        }
        return purchaseUnitId;
    }

    private static String translateResponse(PayPalSaveOrderResponseData saveOrderData) {
            return saveOrderData.getPurchaseUnits().stream().map(PurchaseUnitData::getId).findFirst()
                .orElseThrow(() -> new IllegalArgumentException(PURCHASE_UNIT_ERROR));

    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}
