package com.paypal.hybris.core.commands.impl;

import com.paypal.core.PayPalEnvironment;
import com.paypal.hybris.core.commands.PayPalAbstractCommand;
import com.paypal.hybris.core.constants.PaypalcoreConstants;
import com.paypal.hybris.data.PayPalOrderDetailsData;
import com.paypal.hybris.data.PayPalOrderResponseData;
import de.hybris.platform.payment.AdapterException;
import de.hybris.platform.payment.commands.Command;
import org.apache.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import de.hybris.platform.servicelayer.dto.converter.Converter;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.CHECKOUT_URL;


public class DefaultPayPalGetOrderDetailsCommand extends PayPalAbstractCommand
        implements Command<String, PayPalOrderDetailsData> {
    private static final String ORDER_DETAILS_EXCEPTION = "Getting order details failed for order. OrderId: '%s' \nException: \n %s";
    private static final Logger LOG = Logger.getLogger(DefaultPayPalGetOrderDetailsCommand.class);

    private RestTemplate restTemplate;
    private Converter<PayPalOrderResponseData, PayPalOrderDetailsData> orderResponseToDetailsConverter;

    @Override
    public PayPalOrderDetailsData perform(final String payPalOrderId) {
        final HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(PaypalcoreConstants.AUTHORIZATION_HEADER, createAPIContext().getAccessToken());

        final ResponseEntity<PayPalOrderResponseData> response = getPayPalOrderDetails(payPalOrderId, headers);

        return translateResponse(response);
    }

    private ResponseEntity<PayPalOrderResponseData> getPayPalOrderDetails(String payPalOrderId, HttpHeaders headers) {
        PayPalEnvironment payPalEnvironment = createPayPalEnvironment();
        HttpEntity<MultiValueMap<String, String>> httpEntity = new HttpEntity<>(headers);
        String getOrderURL = payPalEnvironment.baseUrl() + CHECKOUT_URL + payPalOrderId;
        try {
            return restTemplate.exchange(getOrderURL, HttpMethod.GET, httpEntity, PayPalOrderResponseData.class);
        } catch (Exception ex) {
            LOG.error(ORDER_DETAILS_EXCEPTION.formatted(payPalOrderId, ex));
            throw new AdapterException(ex.getMessage());
        }
    }

    private PayPalOrderDetailsData translateResponse(ResponseEntity<PayPalOrderResponseData> payPalResponse) {
        if (payPalResponse == null || payPalResponse.getBody() == null) {
            return null;
        }
        final PayPalOrderResponseData payPalOrder = payPalResponse.getBody();
        return orderResponseToDetailsConverter.convert(payPalOrder);
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setOrderResponseToDetailsConverter(Converter<PayPalOrderResponseData, PayPalOrderDetailsData> orderResponseToDetailsConverter) {
        this.orderResponseToDetailsConverter = orderResponseToDetailsConverter;
    }
}
