package com.paypal.hybris.core.commands.impl;

import com.paypal.api.payments.Event;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.hybris.core.commands.PayPalAbstractCommand;
import de.hybris.platform.payment.AdapterException;
import de.hybris.platform.payment.commands.Command;
import org.apache.log4j.Logger;


public class DefaultPayPalGetEventCommand extends PayPalAbstractCommand implements Command<String, Event> {

    private static final Logger LOG = Logger.getLogger(DefaultPayPalGetEventCommand.class);

    @Override
    public Event perform(String eventId) {
        try {
            return Event.get(createAPIContext(), eventId);
        } catch (PayPalRESTException e) {
            LOG.error(e.getMessage(), e);
            throw new AdapterException();
        }
    }
}
