package com.paypal.hybris.core.commands.impl;

import com.paypal.core.PayPalEnvironment;
import com.paypal.hybris.core.commands.PayPalAbstractCommand;
import com.paypal.hybris.core.constants.PaypalcoreConstants;
import com.paypal.hybris.data.CardData;
import com.paypal.hybris.data.PayPalGetCardDetailsResponseData;
import com.paypal.hybris.data.PaymentSourceData;
import de.hybris.platform.payment.AdapterException;
import de.hybris.platform.payment.commands.Command;
import org.apache.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import java.util.Optional;

public class DefaultPayPalGetCardDetailsCommand extends PayPalAbstractCommand
    implements Command<String, Optional<CardData>> {

    private static final Logger LOG = Logger.getLogger(DefaultPayPalGetCardDetailsCommand.class);
    private static final String GET_PAYMENT_SOURCE_BY_TOKEN_URL = "/v3/vault/payment-tokens/";
    private static final String GET_CARD_DATA_FAILURE_MESSAGE = "Error getting card data";

    private RestTemplate restTemplate;

    @Override
    public Optional<CardData> perform(String token) {
        PayPalEnvironment payPalEnvironment = createPayPalEnvironment();
        final HttpHeaders headers = new HttpHeaders();
        final String getCardDataUrl = payPalEnvironment.baseUrl() + GET_PAYMENT_SOURCE_BY_TOKEN_URL + token;
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(PaypalcoreConstants.AUTHORIZATION_HEADER, createAPIContext().getAccessToken());
        final HttpEntity<MultiValueMap<String, String>> httpEntity = new HttpEntity<>(headers);
        final ResponseEntity<PayPalGetCardDetailsResponseData> response;
        try{
            response = restTemplate.exchange(getCardDataUrl, HttpMethod.GET, httpEntity, PayPalGetCardDetailsResponseData.class);
        }catch (Exception e){
            LOG.error(GET_CARD_DATA_FAILURE_MESSAGE, e);
            throw new AdapterException(getDescriptionFromPayPalErrorMessage(e.getMessage()));
        }
        return Optional.ofNullable(response.getBody())
            .map(PayPalGetCardDetailsResponseData::getPaymentSource)
            .map(PaymentSourceData::getCard);
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}
