package com.paypal.hybris.core.commands.impl;

import com.paypal.hybris.core.commands.PayPalAbstractCommand;
import com.paypal.hybris.core.constants.PaypalcoreConstants;
import de.hybris.platform.payment.commands.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import javax.ws.rs.core.Response;

public class DefaultPayPalDeletePaymentTokenCommand extends PayPalAbstractCommand
        implements Command<String, Boolean> {

    private static final Logger LOG = LoggerFactory.getLogger(DefaultPaypalCreatePaymentTokenCommand.class);
    private static final String PAYMENT_TOKEN_URL = "https://api-m.sandbox.paypal.com/v3/vault/payment-tokens";
    private static final String DELETE_PAYMENT_TOKEN_FAILURE_MESSAGE = "Error deleting payment token";

    private RestTemplate restTemplate;

    @Override
    public Boolean perform(String subscriptionId) {
        final HttpHeaders headers = new HttpHeaders();
        final String deleteCardTokenUrl = PAYMENT_TOKEN_URL + "/" + subscriptionId;
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(PaypalcoreConstants.AUTHORIZATION_HEADER, createAPIContext().getAccessToken());
        final HttpEntity<MultiValueMap<String, String>> httpEntity = new HttpEntity<>(headers);
        ResponseEntity<Response> response;
        try {
             response = restTemplate.exchange(deleteCardTokenUrl, HttpMethod.DELETE, httpEntity, Response.class);
        } catch (Exception e) {
            LOG.error(DELETE_PAYMENT_TOKEN_FAILURE_MESSAGE, e);
            return false;
        }
        return response.getStatusCode().equals(HttpStatus.NO_CONTENT);
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}
