package com.paypal.hybris.core.commands.impl;

import com.paypal.core.PayPalEnvironment;
import com.paypal.hybris.core.commands.PayPalAbstractCommand;
import com.paypal.hybris.core.constants.PaypalcoreConstants;
import com.paypal.hybris.data.PayPalConvertBAToPaymentTokensRequestData;
import com.paypal.hybris.data.PayPalGetCardDetailsResponseData;
import de.hybris.platform.payment.AdapterException;
import de.hybris.platform.payment.commands.Command;
import org.apache.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import java.util.Optional;

public class DefaultPayPalConvertBAToPaymentTokensCommand extends PayPalAbstractCommand
        implements Command<PayPalConvertBAToPaymentTokensRequestData, Optional<PayPalGetCardDetailsResponseData>> {

    private static final Logger LOG = Logger.getLogger(DefaultPayPalConvertBAToPaymentTokensCommand.class);
    private static final String GET_PAYMENT_SOURCE_BY_TOKEN_URL = "/v3/vault/payment-tokens";
    private static final String ERROR_DURING_CONVERTING_BILLING_AGREEMENTS_TO_PAYMENT_TOKENS = "Error during converting billing agreements to payment tokens";

    private RestTemplate restTemplate;

    @Override
    public Optional<PayPalGetCardDetailsResponseData> perform(PayPalConvertBAToPaymentTokensRequestData convertBAToPaymentTokensRequestData) {
        final HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(PaypalcoreConstants.AUTHORIZATION_HEADER, createAPIContext().getAccessToken());
        final ResponseEntity<PayPalGetCardDetailsResponseData> response = getPayPalGetCardDetailsResponseData(convertBAToPaymentTokensRequestData, headers);
        return Optional.ofNullable(response.getBody());
    }

    private ResponseEntity<PayPalGetCardDetailsResponseData> getPayPalGetCardDetailsResponseData(PayPalConvertBAToPaymentTokensRequestData convertBAToPaymentTokensRequestData, HttpHeaders headers) {
        PayPalEnvironment payPalEnvironment = createPayPalEnvironment();
        final String getCardDataUrl = payPalEnvironment.baseUrl() + GET_PAYMENT_SOURCE_BY_TOKEN_URL;
        final HttpEntity<PayPalConvertBAToPaymentTokensRequestData> httpEntity = new HttpEntity<>(convertBAToPaymentTokensRequestData, headers);
        try {
            return restTemplate.postForEntity(getCardDataUrl, httpEntity, PayPalGetCardDetailsResponseData.class);
        } catch (Exception e) {
            LOG.error(ERROR_DURING_CONVERTING_BILLING_AGREEMENTS_TO_PAYMENT_TOKENS, e);
            throw new AdapterException(e.getMessage());
        }
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}