package com.paypal.hybris.core.attributehandlers;

import de.hybris.platform.core.Registry;
import de.hybris.platform.core.model.media.MediaModel;
import de.hybris.platform.media.url.PrettyUrlStrategy;
import de.hybris.platform.media.url.impl.PrettyUrlStrategyFactory;
import de.hybris.platform.servicelayer.model.attribute.DynamicAttributeHandler;
import de.hybris.platform.util.MediaUtil;
import org.apache.commons.lang3.StringUtils;

import java.util.Optional;

public class DefaultPayPalPrettyImgUrlHandler implements DynamicAttributeHandler<String, MediaModel> {

    private static final String MEDIA_WEB_ROOT = "/medias";

    @Override
    public String get(MediaModel mediaModel) {
        String folderQualifier = mediaModel.getFolder() != null ? mediaModel.getFolder().getQualifier()
                : StringUtils.EMPTY;
        return assembleURL(folderQualifier, mediaModel).orElse(StringUtils.EMPTY);
    }

    @Override
    public void set(MediaModel model, String s) {
        throw new UnsupportedOperationException("Url could not be set");
    }

    private Optional<String> assembleURL(String folderQualifier, MediaModel mediaModel) {
        StringBuilder sb = new StringBuilder(MediaUtil.addTrailingFileSepIfNeeded(MEDIA_WEB_ROOT));
        PrettyUrlStrategy.MediaData mediaData = new PrettyUrlStrategy.MediaData(this.getTenantId(), folderQualifier, mediaModel.getLocation());
        mediaData.setRealFileName(mediaModel.getRealFileName());
        Optional<String> prettyPath = PrettyUrlStrategyFactory.getDefaultPrettyUrlStrategy().assemblePath(mediaData);
        return prettyPath.map(sb::append).map(Object::toString);
    }

    protected String getTenantId() {
        return Registry.getCurrentTenantNoFallback().getTenantID();
    }

}
