import de.hybris.platform.core.servicelayer.data.SearchPageData
import de.hybris.platform.servicelayer.search.FlexibleSearchQuery
import de.hybris.platform.servicelayer.search.paginated.PaginatedFlexibleSearchParameter
import de.hybris.platform.servicelayer.search.paginated.util.PaginatedSearchUtils
import org.apache.commons.lang.math.NumberUtils
import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import com.paypal.hybris.core.enums.PaymentProvider;
import com.paypal.hybris.core.enums.ExpirationStatus;

modelService=spring.getBean("modelService")
flexibleSearchService = spring.getBean('flexibleSearchService')
paginatedFlexibleSearchService = spring.getBean('paginatedFlexibleSearchService')

COUNT_OF_PAYMENT_INFOS_QUERY =
        'SELECT count({p:pk}) FROM  {PayPalCreditCardPaymentInfo as p }'

GET_PAYMENT_INFOS_QUERY =
        'SELECT {p:pk} FROM  {PayPalCreditCardPaymentInfo as p }'

pageSize = 1000

FlexibleSearchQuery flexibleSearchQuery = new FlexibleSearchQuery(COUNT_OF_PAYMENT_INFOS_QUERY)
flexibleSearchQuery.setResultClassList(Arrays.asList(Integer.class))
int count = flexibleSearchService.searchUnique(flexibleSearchQuery)
int lastPage = getLastPage(count, pageSize)

for (int page = 0; page <= lastPage; page++) {
    searchPaymentInfo(page).each{
        updatePaymentInfo(it as PayPalCreditCardPaymentInfoModel);
    }
}

void updatePaymentInfo(PayPalCreditCardPaymentInfoModel paymentInfo){
    paymentInfo.setPayPalOrderId(paymentInfo.getSubscriptionId())
    paymentInfo.setSubscriptionId("SUBSCRIPTION_ID_PLACEHOLDER")
    paymentInfo.setPaymentProvider(PaymentProvider.PAYPAL)
    paymentInfo.setExpirationStatus(ExpirationStatus.NOT_APPLICABLE)
    modelService.save(paymentInfo)
}

List<PayPalCreditCardPaymentInfoModel> searchPaymentInfo(int page) {
    SearchPageData searchPageData = PaginatedSearchUtils.createSearchPageDataWithPagination(pageSize, page, true)
    final PaginatedFlexibleSearchParameter parameter = new PaginatedFlexibleSearchParameter()
    parameter.setSearchPageData(searchPageData)
    final FlexibleSearchQuery flexibleQuery = new FlexibleSearchQuery(GET_PAYMENT_INFOS_QUERY)
    parameter.setFlexibleSearchQuery(flexibleQuery)
    SearchPageData<PayPalCreditCardPaymentInfoModel> result = paginatedFlexibleSearchService.search(parameter)
    return result.getResults()
}

int getLastPage(int totalCountOfCustomers, int pageSize) {
    int lastPage = totalCountOfCustomers / pageSize
    if (totalCountOfCustomers % pageSize == 0) {
        lastPage -= NumberUtils.INTEGER_ONE
    }
    return lastPage;
}

