package paypalcore.groovy

import com.paypal.hybris.data.PayPalConvertBAToPaymentTokensRequestData
import com.paypal.hybris.data.PayPalCustomerData
import com.paypal.hybris.data.PayPalGetCardDetailsResponseData
import com.paypal.hybris.data.PayPalTokenData
import com.paypal.hybris.data.PaymentSourceData
import de.hybris.platform.core.model.user.CustomerModel
import de.hybris.platform.core.servicelayer.data.SearchPageData
import de.hybris.platform.servicelayer.search.FlexibleSearchQuery
import de.hybris.platform.servicelayer.search.paginated.PaginatedFlexibleSearchParameter
import de.hybris.platform.servicelayer.search.paginated.util.PaginatedSearchUtils
import org.apache.commons.lang.math.NumberUtils
import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel

modelService = spring.getBean("modelService")
flexibleSearchService = spring.getBean('flexibleSearchService')
paymentService = spring.getBean('paymentService')
paginatedFlexibleSearchService = spring.getBean('paginatedFlexibleSearchService')

BILLING_AGREEMENT = 'BILLING_AGREEMENT'

FROM_WHERE = 'FROM { PayPalCreditCardPaymentInfo AS p LEFT JOIN CartToOrderCronJob AS cj ON {cj:paymentInfo} = {p:pk} } WHERE (({p:Saved}=true AND {p:Duplicate}=false) OR ({cj:paymentInfo} IS NOT NULL)) AND {p:billingAgreementId} IS NOT NULL'

COUNT_OF_PAYMENT_INFOS_QUERY =
        'SELECT count({p:pk}) ' + FROM_WHERE

GET_PAYMENT_INFOS_QUERY =
        'SELECT {p:pk} ' + FROM_WHERE

pageSize = 1000

FlexibleSearchQuery flexibleSearchQuery = new FlexibleSearchQuery(COUNT_OF_PAYMENT_INFOS_QUERY)
flexibleSearchQuery.setResultClassList(Arrays.asList(Integer.class))
int count = flexibleSearchService.searchUnique(flexibleSearchQuery)
int lastPage = getLastPage(count, pageSize)
println("Was found ${count} payments")
for (int page = 0; page <= lastPage; page++) {
    searchPaymentInfo(page).each {
        updatePaymentInfo(it as PayPalCreditCardPaymentInfoModel)
    }
}

void updatePaymentInfo(PayPalCreditCardPaymentInfoModel paymentInfo) {
    Optional<String> billingAgreementToken = Optional.ofNullable(paymentInfo.getBillingAgreementId());
    billingAgreementToken.ifPresent { bAToken ->
        try {
            CustomerModel customer = paymentInfo.getUser() as CustomerModel
            String vaultCustomerId = customer.getVaultCustomerId()
            paymentService.convertBillingAgreementTokenToVault(getRequestData(vaultCustomerId, bAToken)).ifPresent { convertResponse ->
                PayPalGetCardDetailsResponseData detailsResponseData = convertResponse

                if (vaultCustomerId == null) {
                    customer.setVaultCustomerId(detailsResponseData.getCustomer().getId())
                }
                if (!paymentInfo.getCartToOrderCronJob().isEmpty()) {
                    paymentInfo.setSaved(true)
                }
                paymentInfo.setSubscriptionId(detailsResponseData.getId())
                paymentInfo.setBillingAgreementId(null)

                modelService.saveAll(paymentInfo, customer)
                println("Payment method [${paymentInfo.pk}] with billing agreement token - [${bAToken}] was successfuly converted")
            }
        } catch (Exception e) {
            println("Convertion of payment with billing agreement token - [${bAToken}] was failed: ${e.getMessage()}")
        }
    }
}

PayPalConvertBAToPaymentTokensRequestData getRequestData(String vaultCustomerId, String billingAgreementToken) {
    PayPalConvertBAToPaymentTokensRequestData payPalConvertBAToPaymentTokensRequestData = new PayPalConvertBAToPaymentTokensRequestData()
    PaymentSourceData paymentSourceData = new PaymentSourceData()
    PayPalTokenData payPalTokenData = new PayPalTokenData()
    PayPalCustomerData customerData = new PayPalCustomerData()

    customerData.setId(vaultCustomerId)
    payPalTokenData.setType(BILLING_AGREEMENT)
    payPalTokenData.setId(billingAgreementToken
    )
    paymentSourceData.setToken(payPalTokenData)
    payPalConvertBAToPaymentTokensRequestData.setCustomer(customerData)
    payPalConvertBAToPaymentTokensRequestData.setPaymentSource(paymentSourceData)

    return payPalConvertBAToPaymentTokensRequestData
}


List<PayPalCreditCardPaymentInfoModel> searchPaymentInfo(int page) {
    SearchPageData searchPageData = PaginatedSearchUtils.createSearchPageDataWithPagination(pageSize, page, true)
    final PaginatedFlexibleSearchParameter parameter = new PaginatedFlexibleSearchParameter()
    parameter.setSearchPageData(searchPageData)
    final FlexibleSearchQuery flexibleQuery = new FlexibleSearchQuery(GET_PAYMENT_INFOS_QUERY)
    parameter.setFlexibleSearchQuery(flexibleQuery)
    SearchPageData<PayPalCreditCardPaymentInfoModel> result = paginatedFlexibleSearchService.search(parameter)
    return result.getResults()
}

int getLastPage(int totalCountOfCustomers, int pageSize) {
    int lastPage = (int) (totalCountOfCustomers / pageSize)
    if (totalCountOfCustomers % pageSize == 0) {
        lastPage -= NumberUtils.INTEGER_ONE
    }
    return lastPage;
}