package com.paypal.hybris.backoffice.widgets.order.voidorder;

import com.hybris.backoffice.i18n.BackofficeLocaleService;
import com.hybris.cockpitng.core.events.CockpitEventQueue;
import com.hybris.cockpitng.engine.WidgetInstanceManager;
import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import com.paypal.hybris.core.service.PayPalPaymentService;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.basecommerce.enums.CancelReason;
import de.hybris.platform.core.PK;
import de.hybris.platform.core.enums.OrderStatus;
import de.hybris.platform.core.model.order.AbstractOrderEntryModel;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.core.model.order.delivery.DeliveryModeModel;
import de.hybris.platform.core.model.order.payment.PaymentInfoModel;
import de.hybris.platform.core.model.product.ProductModel;
import de.hybris.platform.core.model.user.UserModel;
import de.hybris.platform.enumeration.EnumerationService;
import de.hybris.platform.omsbackoffice.dto.OrderEntryToCancelDto;
import de.hybris.platform.ordercancel.OrderCancelEntry;
import de.hybris.platform.ordercancel.OrderCancelException;
import de.hybris.platform.ordercancel.OrderCancelRequest;
import de.hybris.platform.ordercancel.OrderCancelService;
import de.hybris.platform.ordercancel.model.OrderCancelRecordEntryModel;
import de.hybris.platform.servicelayer.model.ModelService;
import de.hybris.platform.storelocator.model.PointOfServiceModel;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.zkoss.zk.ui.event.Event;

import de.hybris.platform.servicelayer.user.UserService;
import org.junit.Before;
import org.junit.Test;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Grid;
import org.zkoss.zul.Intbox;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Messagebox;
import org.zkoss.zul.Row;
import org.zkoss.zul.Rows;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.impl.InputElement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

import static com.paypal.hybris.backoffice.constants.PaypalbackofficeConstants.OrderManagementActions.CANCELORDER_ERROR;
import static com.paypal.hybris.backoffice.constants.PaypalbackofficeConstants.OrderManagementActions.CANCELORDER_TITLE;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotEquals;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.any;
import static org.mockito.Mockito.anyBoolean;
import static org.mockito.Mockito.anyInt;
import static org.mockito.Mockito.anyString;
import static org.mockito.Mockito.doNothing;
import static org.mockito.Mockito.doReturn;
import static org.mockito.Mockito.doThrow;
import static org.mockito.Mockito.eq;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class PayPalVoidControllerTest {

    private static final String CONFIRM_ID = "confirmcancellation";
    private static final Object COMPLETED = "completed";
    private static final String CUSTOMERSUPPORTBACKOFFICE_CANCELORDER_PICKUP = "customersupportbackoffice.cancelorder.pickup";
    private static final String CUSTOMERSUPPORTBACKOFFICE_CANCELORDER_CONFIRM_TITLE = "customersupportbackoffice.cancelorder.confirm.title";
    private static final String CUSTOMERSUPPORTBACKOFFICE_CANCELORDER_ERROR_QTYCANCELLED_INVALID = "customersupportbackoffice.cancelorder.error.qtycancelled.invalid";
    private static final String CUSTOMERSUPPORTBACKOFFICE_CANCELORDER_MISSING_QUANTITY = "customersupportbackoffice.cancelorder.missing.quantity";
    private static final String CUSTOMERSUPPORTBACKOFFICE_CANCELORDER_ERROR_REASON = "customersupportbackoffice.cancelorder.error.reason";
    private static final String CUSTOMERSUPPORTBACKOFFICE_CANCELORDER_MISSING_SELECTED_LINE = "customersupportbackoffice.cancelorder.missing.selectedLine";
    private static final String ON_CHECK = "onCheck";
    private static final String ON_CUSTOM_CHANGE = "onCustomChange";
    private static final String ON_LATER_CUSTOM_CHANGE = "onLaterCustomChange";
    private static final String ON_CHANGE = "onChange";
    private static final String ON_CHANGING = "onChanging";
    private static final String ON_SELECT = "onSelect";
    private static final String CODE = "code";
    private static final String STRING_TO_VALIDATE = "stringToValidate";
    private static final String VALUE = "value";
    private static final String ORDER_CODE = "orderCode";
    private static final String CANCEL_REASON_LABEL = "cancelReasonLabel";
    private static final String REASON = "reason";
    private static final String COMMENT = "Comment";
    private static final String NAME = "name";

    @Mock
    private Map<AbstractOrderEntryModel, Long> orderCancellableEntries;

    @Mock
    private Set<OrderEntryToCancelDto> orderEntriesToCancel;

    @Mock
    private CancelReason cancelReason;

    @Mock
    private WidgetInstanceManager widgetInstanceManager;

    @Mock
    private OrderModel orderModel;

    @Mock
    private AbstractOrderEntryModel abstractOrderEntryModel;

    @Mock
    private PayPalCreditCardPaymentInfoModel paymentInfoModel;

    @Mock
    private PaymentInfoModel notCardPaymentInfoModel;

    @Mock
    private Textbox orderNumber;

    @Mock
    private ProductModel productModel;

    @Mock
    private UserModel userModel;

    @Mock
    private Textbox customerName;

    @Mock
    private Combobox globalCancelReasons;

    @Mock
    private Comboitem comboitem;

    @Mock
    private Textbox globalCancelComment;

    @Mock
    private Grid orderEntries;

    @Mock
    private Intbox intbox;

    @Mock
    private Textbox textbox;

    @Mock
    private Checkbox row;

    @Mock
    private Event event;

    @Mock
    private InputEvent inputEvent;

    @Mock
    private SelectEvent selectEvent;

    @Mock
    private Component component1;

    @Mock
    private Component component2;

    @Mock
    private Label label1;

    @Mock
    private Combobox combobox;

    @Mock
    private Label label2;

    @Mock
    private Rows rows;

    @Mock
    private Row rowComponent;

    @Mock
    private DeliveryModeModel deliveryModeModel;

    @Mock
    private PointOfServiceModel pointOfServiceModel;

    @Mock
    private InputElement cancelQty;

    @Mock
    private Checkbox globalCancelEntriesSelection;

    @Mock
    private BackofficeLocaleService cockpitLocaleService;

    @Mock
    private OrderCancelService orderCancelService;

    @Mock
    private EnumerationService enumerationService;

    @Mock
    private ModelService modelService;

    @Mock
    private CockpitEventQueue cockpitEventQueue;

    @Mock
    private UserService userService;

    @Mock
    private PayPalPaymentService paymentService;

    @Spy
    @InjectMocks
    private PayPalVoidController unit;

    private List<String> cancelReasons;

    private OrderEntryToCancelDto orderEntryToCancelDto;

    private OrderCancelEntry orderCancelEntry;

    private OrderCancelRequest orderCancelRequest;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);

        doNothing().when(unit).showMessageBox(any(), anyString(), anyInt(), anyString());
        doNothing().when(unit).showMessageBox();

        cancelReasons = new ArrayList<>();
        orderEntryToCancelDto = new OrderEntryToCancelDto(abstractOrderEntryModel, cancelReasons, 12L, "name");
        orderCancelEntry = new OrderCancelEntry(abstractOrderEntryModel);
        orderCancelRequest = new OrderCancelRequest(orderModel);
    }

    @Test
    public void shouldAddListenersWhenComponentTextBox() {
        when(orderEntries.getRows()).thenReturn(rows);
        when(rows.getChildren()).thenReturn(Collections.singletonList(row));
        when(row.getChildren()).thenReturn(Collections.singletonList(intbox));

        unit.addListeners();

        verify(intbox).addEventListener(eq(ON_CHANGE), any());
        verify(globalCancelReasons).addEventListener(eq(ON_SELECT), any());
        verify(globalCancelComment).addEventListener(eq(ON_CHANGING), any());
        verify(globalCancelEntriesSelection).addEventListener(eq(ON_CHECK), any());
    }

    @Test
    public void shouldAddListenersWhenComponentIntBox() {
        when(orderEntries.getRows()).thenReturn(rows);
        when(rows.getChildren()).thenReturn(Collections.singletonList(row));
        when(row.getChildren()).thenReturn(Collections.singletonList(intbox));

        unit.addListeners();

        verify(intbox).addEventListener(eq(ON_CHANGE), any());
        verify(globalCancelReasons).addEventListener(eq(ON_SELECT), any());
        verify(globalCancelComment).addEventListener(eq(ON_CHANGING), any());
        verify(globalCancelEntriesSelection).addEventListener(eq(ON_CHECK), any());
    }

    @Test
    public void shouldAddListenersWhenComponentCombobox() {
        when(orderEntries.getRows()).thenReturn(rows);
        when(rows.getChildren()).thenReturn(Collections.singletonList(row));
        when(row.getChildren()).thenReturn(Collections.singletonList(combobox));

        unit.addListeners();

        verify(combobox).addEventListener(eq(ON_CUSTOM_CHANGE), any());
        verify(combobox).addEventListener(eq(ON_LATER_CUSTOM_CHANGE), any());
        verify(globalCancelReasons).addEventListener(eq(ON_SELECT), any());
        verify(globalCancelComment).addEventListener(eq(ON_CHANGING), any());
        verify(globalCancelEntriesSelection).addEventListener(eq(ON_CHECK), any());
    }

    @Test
    public void shouldAddListenersWhenComponentCheckbox() {
        when(orderEntries.getRows()).thenReturn(rows);
        when(rows.getChildren()).thenReturn(Collections.singletonList(row));
        when(row.getChildren()).thenReturn(Collections.singletonList(row));

        unit.addListeners();

        verify(row).addEventListener(eq(ON_CHECK), any());
        verify(globalCancelReasons).addEventListener(eq(ON_SELECT), any());
        verify(globalCancelComment).addEventListener(eq(ON_CHANGING), any());
        verify(globalCancelEntriesSelection).addEventListener(eq(ON_CHECK), any());
    }

    @Test
    public void shouldAddListenersWhenHasNotNext() {
        when(orderEntries.getRows()).thenReturn(rows);
        when(rows.getChildren()).thenReturn(Collections.emptyList());


        doNothing().when(unit).handleGlobalCancelReason(any());
        doNothing().when(unit).handleGlobalCancelComment(any());
        doNothing().when(unit).selectAllEntries(anyBoolean());

        unit.addListeners();

        verify(globalCancelReasons).addEventListener(eq(ON_SELECT), any());
        verify(globalCancelComment).addEventListener(eq(ON_CHANGING), any());
        verify(globalCancelEntriesSelection).addEventListener(eq(ON_CHECK), any());
    }

    @Test
    public void initCancellationOrderFormWhenPaymentIsCreditCard() {
        when(orderModel.getCode()).thenReturn(ORDER_CODE);
        when(orderModel.getUser()).thenReturn(userModel);
        when(userModel.getDisplayName()).thenReturn(NAME);
        when(widgetInstanceManager.getLabel(CUSTOMERSUPPORTBACKOFFICE_CANCELORDER_CONFIRM_TITLE + " " + ORDER_CODE)).thenReturn(CUSTOMERSUPPORTBACKOFFICE_CANCELORDER_CONFIRM_TITLE);
        doReturn(Locale.US).when(unit).getLocale();

        when(enumerationService.getEnumerationValues(CancelReason.class)).thenReturn(Collections.singletonList(CancelReason.OTHER));
        when(enumerationService.getEnumerationName(CancelReason.OTHER, Locale.US)).thenReturn(CancelReason.OTHER.getCode());

        when(userService.getCurrentUser()).thenReturn(userModel);
        when(orderCancelService.getAllCancelableEntries(orderModel, userModel)).thenReturn(orderCancellableEntries);

        doNothing().when(orderCancellableEntries).forEach(any());

        doNothing().when(unit).addListeners();

        when(orderModel.getPaymentInfo()).thenReturn(paymentInfoModel);

        doNothing().when(unit).selectAllEntries(Boolean.TRUE);

        unit.initCancellationOrderForm(orderModel);

        verify(orderEntries).renderAll();
        verify(orderNumber).setValue(ORDER_CODE);
        verify(customerName).setValue(NAME);
        verify(globalCancelEntriesSelection).setChecked(Boolean.TRUE);
        verify(globalCancelEntriesSelection).setDisabled(Boolean.TRUE);
    }

    @Test
    public void initCancellationOrderFormWhenPaymentIsNotCreditCard() {
        when(orderModel.getCode()).thenReturn(ORDER_CODE);
        when(orderModel.getUser()).thenReturn(userModel);
        when(userModel.getDisplayName()).thenReturn(NAME);
        when(widgetInstanceManager.getLabel(CUSTOMERSUPPORTBACKOFFICE_CANCELORDER_CONFIRM_TITLE + " " + ORDER_CODE)).thenReturn(CUSTOMERSUPPORTBACKOFFICE_CANCELORDER_CONFIRM_TITLE);
        doReturn(Locale.US).when(unit).getLocale();

        when(enumerationService.getEnumerationValues(CancelReason.class)).thenReturn(Collections.singletonList(CancelReason.OTHER));
        when(enumerationService.getEnumerationName(CancelReason.OTHER, Locale.US)).thenReturn(CancelReason.OTHER.getCode());

        when(userService.getCurrentUser()).thenReturn(userModel);
        when(orderCancelService.getAllCancelableEntries(orderModel, userModel)).thenReturn(orderCancellableEntries);

        when(orderCancellableEntries.isEmpty()).thenReturn(Boolean.TRUE);

        doNothing().when(unit).addListeners();

        when(orderModel.getPaymentInfo()).thenReturn(notCardPaymentInfoModel);

        unit.initCancellationOrderForm(orderModel);

        verify(orderEntries).renderAll();
        verify(orderNumber).setValue(ORDER_CODE);
        verify(customerName).setValue(NAME);

    }

    @Test
    public void shouldDetermineDeliveryModeWhenDeliveryModeNameFromOrderEqualsNull() {
        when(abstractOrderEntryModel.getOrder()).thenReturn(orderModel);
        when(orderModel.getDeliveryMode()).thenReturn(deliveryModeModel);
        when(deliveryModeModel.getCode()).thenReturn(CODE);

        assertEquals(CODE, unit.determineDeliveryMode(abstractOrderEntryModel));
    }

    @Test
    public void shouldDetermineDeliveryModeWhenDeliveryModeFromOrderEqualsNull() {
        when(abstractOrderEntryModel.getOrder()).thenReturn(orderModel);

        assertNull(unit.determineDeliveryMode(abstractOrderEntryModel));
    }

    @Test
    public void shouldDetermineDeliveryModeWhenDeliveryModeFromOrderNotEqualsNull() {
        when(abstractOrderEntryModel.getOrder()).thenReturn(orderModel);
        when(orderModel.getDeliveryMode()).thenReturn(deliveryModeModel);
        when(deliveryModeModel.getName()).thenReturn(NAME);

        assertEquals(NAME, unit.determineDeliveryMode(abstractOrderEntryModel));
    }


    @Test
    public void shouldDetermineDeliveryModeWhenDeliveryPointOfServiceNotEqualsNull() {
        when(abstractOrderEntryModel.getDeliveryPointOfService()).thenReturn(pointOfServiceModel);

        when(widgetInstanceManager.getLabel(CUSTOMERSUPPORTBACKOFFICE_CANCELORDER_PICKUP)).thenReturn(CUSTOMERSUPPORTBACKOFFICE_CANCELORDER_PICKUP);

        assertEquals(CUSTOMERSUPPORTBACKOFFICE_CANCELORDER_PICKUP, unit.determineDeliveryMode(abstractOrderEntryModel));
    }

    @Test
    public void shouldDetermineDeliveryModeWhenDeliveryModeNotEqualsNull() {
        when(abstractOrderEntryModel.getDeliveryMode()).thenReturn(deliveryModeModel);
        when(deliveryModeModel.getName()).thenReturn(NAME);

        assertEquals(NAME, unit.determineDeliveryMode(abstractOrderEntryModel));
    }

    @Test
    public void reset() {
        doNothing().when(unit).initCancellationOrderForm(orderModel);

        unit.reset();

        verify(globalCancelReasons).setSelectedItem(null);
        verify(globalCancelComment).setValue("");
    }

    @Test
    public void shouldApplyToGrid() {
        when(orderEntries.getRows()).thenReturn(rows);
        when(rows.getChildren()).thenReturn(Collections.singletonList(row));
        when(row.getChildren()).thenReturn(Collections.singletonList(row));
        when(row.isChecked()).thenReturn(Boolean.TRUE);
        doNothing().when(unit).applyToRow(any(), anyInt(), any(), anyBoolean());

        unit.applyToGrid(VALUE, 1);

        verify(unit).applyToRow(any(), anyInt(), any(), anyBoolean());

    }

    @Test
    public void shouldSelectAllEntriesWhenPayPalFalseAndGlobalCancelEntriesSelectionIsChecked() {
        doNothing().when(unit).applyToGrid(Boolean.TRUE, 0);

        when(orderEntries.getRows()).thenReturn(rows);
        when(rows.getChildren()).thenReturn(Collections.singletonList(rowComponent));
        when(rowComponent.getChildren()).thenReturn(List.of(row, row, row, row, label1));
        when(globalCancelEntriesSelection.isChecked()).thenReturn(Boolean.TRUE);

        doNothing().when(unit).handleRow(rowComponent);

        when(label1.getValue()).thenReturn("1");

        doNothing().when(unit).applyToRow(any(), anyInt(), any(), anyBoolean());

        doNothing().when(orderEntriesToCancel).forEach(any());

        unit.selectAllEntries(Boolean.FALSE);

        verify(row).setChecked(Boolean.TRUE);
    }

    @Test
    public void shouldSelectAllEntriesWhenPayPalTrueAndGlobalCancelEntriesSelectionIsNotChecked() {
        doNothing().when(unit).applyToGrid(Boolean.TRUE, 0);

        when(orderEntries.getRows()).thenReturn(rows);
        when(rows.getChildren()).thenReturn(Collections.singletonList(rowComponent));
        when(rowComponent.getChildren()).thenReturn(List.of(row));
        when(globalCancelEntriesSelection.isChecked()).thenReturn(Boolean.FALSE);

        doNothing().when(globalCancelEntriesSelection).setChecked(Boolean.TRUE);

        doNothing().when(unit).handleRow(rowComponent);

        unit.selectAllEntries(Boolean.TRUE);

        verify(row, times(2)).setChecked(anyBoolean());
        verify(row).setDisabled(Boolean.TRUE);
        verify(globalCancelEntriesSelection).setChecked(Boolean.TRUE);
    }

    @Test
    public void shouldApplyToRowWhenComponentTextBox(){
        when(component1.getChildren()).thenReturn(List.of(component1, textbox));

        unit.applyToRow(VALUE, 1, component1, Boolean.TRUE);

        verify(textbox).setValue(VALUE);
    }

    @Test
    public void shouldApplyToRowWhenComponentIntBox(){
        when(component1.getChildren()).thenReturn(List.of(component1, intbox));

        unit.applyToRow(2, 1, component1, Boolean.TRUE);

        verify(intbox).setValue(2);
        verify(intbox).setDisabled(Boolean.TRUE);
    }


    @Test
    public void shouldApplyToRowWhenComponentCombobox() {
        when(component1.getChildren()).thenReturn(List.of(component1, globalCancelReasons));

        unit.applyToRow(2, 1, component1, Boolean.TRUE);

        verify(globalCancelReasons).setSelectedIndex(2);
    }

    @Test
    public void shouldApplyToRowWhenComponentCheckbox() {
        when(component1.getChildren()).thenReturn(List.of(component1, row));

        unit.applyToRow(Boolean.TRUE, 1, component1, Boolean.TRUE);

        verify(row).setChecked(Boolean.TRUE);
    }

    @Test
    public void shouldAutoSelect() {
        when(event.getTarget()).thenReturn(row);
        when(row.getParent()).thenReturn(row);
        when(row.getChildren()).thenReturn(Collections.singletonList(row));

        unit.autoSelect(event);

        verify(row).setChecked(Boolean.TRUE);
    }

    @Test(expected = IllegalArgumentException.class)
    public void shouldThrowIllegalArgumentExceptionDuringBuildCancelRequest() {
        unit.setOrderModel(orderModel);

        when(orderEntries.getRows()).thenReturn(rows);
        when(rows.getChildren()).thenReturn(Collections.emptyList());

        unit.buildCancelRequest();
    }

    @Test
    public void shouldNotBuildCancelRequestWhenOrderNull() {
        unit.setOrderModel(null);

        assertNull(unit.buildCancelRequest());
    }

    @Test
    public void createOrderCancelEntry() {
        List<OrderCancelEntry> list = new ArrayList<>();
        orderEntryToCancelDto.setOrderEntry(abstractOrderEntryModel);
        orderEntryToCancelDto.setQuantityToCancel(0L);
        orderEntryToCancelDto.setCancelOrderEntryComment(COMMENT);
        orderEntryToCancelDto.setSelectedReason(CancelReason.OTHER);

        unit.createOrderCancelEntry(list, orderEntryToCancelDto);

        assertFalse(list.isEmpty());
    }

    @Test
    public void shouldGetReasonIndex() {
        when(enumerationService.getEnumerationName(cancelReason, Locale.US)).thenReturn(CancelReason.OTHER.getCode());
        when(cockpitLocaleService.getCurrentLocale()).thenReturn(Locale.US);

        assertEquals(0, unit.getReasonIndex(cancelReason));
    }

    @Test
    public void shouldReturnSelectedCancelReason() {
        when(selectEvent.getSelectedItems()).thenReturn(Set.of(comboitem));
        when(comboitem.getValue()).thenReturn(CancelReason.OTHER);
        doReturn(Optional.of(CancelReason.OTHER)).when(unit).matchingComboboxCancelReason(CancelReason.OTHER.getCode());

        assertTrue(unit.getSelectedCancelReason(selectEvent).isPresent());
    }

    @Test
    public void shouldReturnEmptySelectedCancelReason() {
        when(selectEvent.getSelectedItems()).thenReturn(Collections.emptySet());

        assertFalse(unit.getSelectedCancelReason(selectEvent).isPresent());
    }

    @Test
    public void shouldHandleGlobalCancelComment() {
        when(inputEvent.getValue()).thenReturn(VALUE);
        doNothing().when(unit).applyToGrid(VALUE, 7);
        when(orderEntries.getRows()).thenReturn(rows);

        when(rows.getChildren()).thenReturn(Collections.emptyList());

        unit.handleGlobalCancelComment(inputEvent);

        assertNotEquals(COMMENT, orderEntryToCancelDto.getCancelOrderEntryComment());
    }

    @Test
    public void shouldHandleGlobalCancelReasonWhenCancelReasonIsPresent() {
        doReturn(Optional.of(CancelReason.OTHER)).when(unit).getSelectedCancelReason(event);
        doReturn(1).when(unit).getReasonIndex(CancelReason.OTHER);
        doNothing().when(unit).applyToGrid(1, 6);

        when(orderEntries.getRows()).thenReturn(rows);
        when(rows.getChildren()).thenReturn(Collections.emptyList());

        unit.handleGlobalCancelReason(event);

        assertNotEquals(CancelReason.OTHER, orderEntryToCancelDto.getSelectedReason());

    }

    @Test
    public void shouldHandleGlobalCancelReasonWhenCancelReasonIsNotPresent() {
        doReturn(Optional.empty()).when(unit).getSelectedCancelReason(event);

        unit.handleGlobalCancelReason(event);

        assertNotEquals(CancelReason.OTHER, orderEntryToCancelDto.getSelectedReason());
    }

    @Test
    public void shouldHandleIndividualCancelReasonWhenCancelReasonIsNotPresent() {
        doReturn(Optional.empty()).when(unit).getCustomSelectedCancelReason(event);

        unit.handleIndividualCancelReason(event);

        assertNotEquals(CancelReason.OTHER, orderEntryToCancelDto.getSelectedReason());
    }

    @Test
    public void shouldHandleIndividualCancelReasonWhenCancelReasonIsPresent() {
        doReturn(Optional.of(CancelReason.OTHER)).when(unit).getCustomSelectedCancelReason(event);
        doNothing().when(unit).autoSelect(event);

        when(event.getTarget()).thenReturn(rowComponent);
        when(rowComponent.getParent()).thenReturn(rowComponent);
        when(rowComponent.getValue()).thenReturn(orderEntryToCancelDto);

        unit.handleIndividualCancelReason(event);

        assertEquals(CancelReason.OTHER, orderEntryToCancelDto.getSelectedReason());
    }

    @Test
    public void shouldHandleRowWhenCheckboxIsCheckedAndSelectedItemNotNull() {
        when(rowComponent.getValue()).thenReturn(orderEntryToCancelDto);
        when(rowComponent.getChildren()).thenReturn(List.of(globalCancelEntriesSelection, globalCancelEntriesSelection));

        when(globalCancelEntriesSelection.isChecked()).thenReturn(Boolean.TRUE);

        doNothing().when(unit).applyToRow(any(), anyInt(), any(), eq(Boolean.FALSE));
        when(globalCancelReasons.getSelectedItem()).thenReturn(comboitem);
        when(comboitem.getLabel()).thenReturn(CancelReason.OTHER.getCode());
        doReturn(Optional.of(CancelReason.OTHER)).when(unit).matchingComboboxCancelReason(CancelReason.OTHER.getCode());
        unit.handleRow(rowComponent);

        assertNull(orderEntryToCancelDto.getCancelOrderEntryComment());
        assertEquals(CancelReason.OTHER, orderEntryToCancelDto.getSelectedReason());
    }

    @Test
    public void shouldHandleRowWhenCheckboxIsNotChecked() {
        when(rowComponent.getValue()).thenReturn(orderEntryToCancelDto);
        when(rowComponent.getChildren()).thenReturn(List.of(globalCancelEntriesSelection, globalCancelEntriesSelection));

        when(globalCancelEntriesSelection.isChecked()).thenReturn(Boolean.FALSE);

        doNothing().when(unit).applyToRow(any(), anyInt(), any(), eq(Boolean.TRUE));

        unit.handleRow(rowComponent);

        assertEquals(Long.valueOf(0L), orderEntryToCancelDto.getQuantityToCancel());
        assertNull(orderEntryToCancelDto.getSelectedReason());
        assertNull(orderEntryToCancelDto.getCancelOrderEntryComment());
    }


    @Test
    public void shouldHandleRowWhenCheckboxIsCheckedAndSelectedItemNull() {
        when(rowComponent.getValue()).thenReturn(orderEntryToCancelDto);
        when(rowComponent.getChildren()).thenReturn(List.of(globalCancelEntriesSelection, globalCancelEntriesSelection));

        when(globalCancelEntriesSelection.isChecked()).thenReturn(Boolean.TRUE);

        doNothing().when(unit).applyToRow(any(), anyInt(), any(), eq(Boolean.FALSE));

        unit.handleRow(rowComponent);

        assertNull(orderEntryToCancelDto.getSelectedReason());
        assertNull(orderEntryToCancelDto.getCancelOrderEntryComment());
    }

    @Test
    public void shouldConfirmCancellation() {
        doNothing().when(unit).validateRequest();

        unit.confirmCancellation();

        verify(unit).showMessageBox();
    }

    @Test
    public void shouldGetCustomSelectedCancelReason() {
        when(event.getTarget()).thenReturn(globalCancelReasons);
        when(event.getData()).thenReturn(CancelReason.OTHER.getCode());

        doReturn(Optional.of(CancelReason.OTHER)).when(unit).matchingComboboxCancelReason(CancelReason.OTHER.getCode());

        assertTrue(unit.getCustomSelectedCancelReason(event).isPresent());
        assertEquals(CancelReason.OTHER, unit.getCustomSelectedCancelReason(event).get());
    }

    @Test
    public void shouldGetEmptyCustomSelectedCancelReason() {
        when(event.getTarget()).thenReturn(row);

        assertFalse(unit.getCustomSelectedCancelReason(event).isPresent());
    }

    @Test
    public void shouldMatchComboboxCancelReason() {
        when(enumerationService.getEnumerationValues(CancelReason.class)).thenReturn(Collections.singletonList(CancelReason.OTHER));
        when(cockpitLocaleService.getCurrentLocale()).thenReturn(Locale.US);
        when(enumerationService.getEnumerationName(any(), eq(Locale.US))).thenReturn(CancelReason.OTHER.getCode());

        assertEquals(CancelReason.OTHER, unit.matchingComboboxCancelReason(CancelReason.OTHER.getCode()).get());
    }

    @Test
    public void shouldProcessCancellationWhenOrderStatusCancelled() throws OrderCancelException {
        when(event.getName()).thenReturn(Messagebox.Button.YES.event);

        doNothing().when(paymentService).doCancelTransactions(orderModel);
        when(userService.getCurrentUser()).thenReturn(userModel);
        doReturn(orderCancelRequest).when(unit).buildCancelRequest();
        doReturn(new OrderCancelRecordEntryModel()).when(orderCancelService).requestOrderCancel(orderCancelRequest, userModel);
        doNothing().when(paymentService).doCancel(orderModel);

        when(orderModel.getStatus()).thenReturn(OrderStatus.CANCELLED);

        when(widgetInstanceManager.getLabel(CANCELORDER_ERROR)).thenReturn(CANCELORDER_ERROR);
        when(widgetInstanceManager.getLabel(CANCELORDER_TITLE)).thenReturn(CANCELORDER_TITLE);

        when(orderModel.getCode()).thenReturn(ORDER_CODE);
        when(orderModel.getPk()).thenReturn(PK.BIG_PK);
        when(orderModel.getEntries()).thenReturn(Collections.singletonList(abstractOrderEntryModel));

        when(modelService.get(PK.BIG_PK)).thenReturn(orderModel);
        doNothing().when(cockpitEventQueue).publishEvent(any());

        unit.processCancellation(event);

        verify(unit).showMessageBox(any(), anyString(), anyInt(), eq(Messagebox.INFORMATION));
        verify(unit).sendOutput(CONFIRM_ID, COMPLETED);
    }

    @Test
    public void shouldProcessCancellationWhenOrderStatusRejected() throws OrderCancelException {
        when(event.getName()).thenReturn(Messagebox.Button.YES.event);

        doNothing().when(paymentService).doCancelTransactions(orderModel);
        when(userService.getCurrentUser()).thenReturn(userModel);
        doReturn(orderCancelRequest).when(unit).buildCancelRequest();
        doReturn(new OrderCancelRecordEntryModel()).when(orderCancelService).requestOrderCancel(orderCancelRequest, userModel);

        when(orderModel.getStatus()).thenReturn(OrderStatus.REJECTED);

        when(widgetInstanceManager.getLabel(CANCELORDER_ERROR)).thenReturn(CANCELORDER_ERROR);
        when(widgetInstanceManager.getLabel(CANCELORDER_TITLE)).thenReturn(CANCELORDER_TITLE);

        when(orderModel.getCode()).thenReturn(ORDER_CODE);
        when(orderModel.getPk()).thenReturn(PK.BIG_PK);
        when(orderModel.getEntries()).thenReturn(Collections.singletonList(abstractOrderEntryModel));

        when(modelService.get(PK.BIG_PK)).thenReturn(orderModel);
        doNothing().when(cockpitEventQueue).publishEvent(any());

        unit.processCancellation(event);

        verify(unit).showMessageBox(any(), anyString(), anyInt(), eq(Messagebox.ERROR));
        verify(unit).sendOutput(CONFIRM_ID, COMPLETED);
    }

    @Test
    public void shouldProcessCancellationWhenDoCancelTransactionsThrowsException() {
        when(event.getName()).thenReturn(Messagebox.Button.YES.event);

        doThrow(RuntimeException.class).when(paymentService).doCancelTransactions(orderModel);

        when(widgetInstanceManager.getLabel(CANCELORDER_TITLE)).thenReturn(CANCELORDER_TITLE);

        when(orderModel.getCode()).thenReturn(ORDER_CODE);
        when(orderModel.getPk()).thenReturn(PK.BIG_PK);
        when(orderModel.getEntries()).thenReturn(Collections.singletonList(abstractOrderEntryModel));

        when(modelService.get(PK.BIG_PK)).thenReturn(orderModel);
        doNothing().when(cockpitEventQueue).publishEvent(any());

        unit.processCancellation(event);

        verify(unit).showMessageBox(any(), anyString(), anyInt(), eq(Messagebox.ERROR));
        verify(unit).sendOutput(CONFIRM_ID, COMPLETED);
    }

    @Test
    public void shouldNotProcessCancellationWhenEventNotYes() {
        when(event.getName()).thenReturn(Messagebox.Button.NO.event);

        unit.processCancellation(event);

        verify(unit, never()).sendOutput(CONFIRM_ID, COMPLETED);
    }

    @Test
    public void shouldReturnChildren() {
        when(orderEntries.getRows()).thenReturn(rows);
        when(rows.getChildren()).thenReturn(List.of(component1, component2));

        when(component1.getChildren()).thenReturn(List.of(label1));
        when(component2.getChildren()).thenReturn(List.of(label2));

        when(label1.getValue()).thenReturn(VALUE);
        when(label2.getValue()).thenReturn(STRING_TO_VALIDATE);

        assertEquals(label2, unit.targetFieldToApplyValidation(STRING_TO_VALIDATE, 0, 0));
    }

    @Test
    public void shouldReturnNullWhenNotOrderEntriesGridRowsWithAppropriateLabel() {
        when(orderEntries.getRows()).thenReturn(rows);
        when(rows.getChildren()).thenReturn(List.of(component1, component2));

        when(component1.getChildren()).thenReturn(List.of(label1));
        when(component2.getChildren()).thenReturn(List.of(label2));

        when(label1.getValue()).thenReturn(VALUE);
        when(label2.getValue()).thenReturn(VALUE);

        assertNull(unit.targetFieldToApplyValidation(STRING_TO_VALIDATE, 0, 0));
    }

    @Test
    public void shouldReturnNullWhenNotOrderEntriesGridRows() {
        when(orderEntries.getRows()).thenReturn(rows);
        when(rows.getChildren()).thenReturn(Collections.emptyList());

        assertNull(unit.targetFieldToApplyValidation(STRING_TO_VALIDATE, 1, 2));
    }

    @Test(expected = WrongValueException.class)
    public void shouldThrowWrongValueExceptionDuringValidationOrderEntryWhenQuantityMoreThanZero() {
        orderEntryToCancelDto.setQuantityToCancel(10L);
        orderEntryToCancelDto.setSelectedReason(null);

        when(orderCancellableEntries.get(abstractOrderEntryModel)).thenReturn(10L);
        when(abstractOrderEntryModel.getProduct()).thenReturn(productModel);
        when(productModel.getCode()).thenReturn(CODE);

        doReturn(globalCancelReasons ).when(unit).targetFieldToApplyValidation(anyString(), anyInt(), anyInt());

        when(widgetInstanceManager.getLabel(CUSTOMERSUPPORTBACKOFFICE_CANCELORDER_ERROR_REASON)).thenReturn(CUSTOMERSUPPORTBACKOFFICE_CANCELORDER_ERROR_REASON);

        unit.validateOrderEntry(orderEntryToCancelDto);
    }

    @Test(expected = WrongValueException.class)
    public void shouldThrowWrongValueExceptionDuringValidationOrderEntryWhenMissingQuantity() {
        orderEntryToCancelDto.setQuantityToCancel(0L);
        orderEntryToCancelDto.setSelectedReason(cancelReason);

        when(orderCancellableEntries.get(abstractOrderEntryModel)).thenReturn(10L);
        when(abstractOrderEntryModel.getProduct()).thenReturn(productModel);
        when(productModel.getCode()).thenReturn(CODE);

        doReturn(cancelQty).when(unit).targetFieldToApplyValidation(anyString(), anyInt(), anyInt());

        when(widgetInstanceManager.getLabel(CUSTOMERSUPPORTBACKOFFICE_CANCELORDER_MISSING_QUANTITY)).thenReturn(CUSTOMERSUPPORTBACKOFFICE_CANCELORDER_MISSING_QUANTITY);

        unit.validateOrderEntry(orderEntryToCancelDto);
    }

    @Test(expected = WrongValueException.class)
    public void shouldThrowWrongValueExceptionDuringValidationOrderEntryWhenQTYCanceledInvalid() {
        orderEntryToCancelDto.setQuantityToCancel(12L);
        when(orderCancellableEntries.get(abstractOrderEntryModel)).thenReturn(10L);
        when(abstractOrderEntryModel.getProduct()).thenReturn(productModel);
        when(productModel.getCode()).thenReturn(CODE);

        doReturn(cancelQty).when(unit).targetFieldToApplyValidation(anyString(), anyInt(), anyInt());

        when(widgetInstanceManager.getLabel(CUSTOMERSUPPORTBACKOFFICE_CANCELORDER_ERROR_QTYCANCELLED_INVALID)).thenReturn(CUSTOMERSUPPORTBACKOFFICE_CANCELORDER_ERROR_QTYCANCELLED_INVALID);

        unit.validateOrderEntry(orderEntryToCancelDto);
    }

    @Test
    public void shouldNotThrowWrongValueExceptionDuringValidationOrderEntry() {
        orderEntryToCancelDto.setQuantityToCancel(12L);
        orderEntryToCancelDto.setSelectedReason(cancelReason);

        when(orderCancellableEntries.get(abstractOrderEntryModel)).thenReturn(13L);

        unit.validateOrderEntry(orderEntryToCancelDto);
    }

    @Test
    public void shouldValidateRequestWhenCheckboxIsNotChecked() {
        ListModel<Object> listModelList = new ListModelList<>(Collections.singletonList(orderEntryToCancelDto));
        when(orderEntries.getRows()).thenReturn(rows);
        when(rows.getChildren()).thenReturn(List.of(row));
        when(row.getChildren()).thenReturn(List.of(row, row));
        when(row.isChecked()).thenReturn(Boolean.FALSE);

        when(orderEntries.getModel()).thenReturn(listModelList);
        orderEntryToCancelDto.setQuantityToCancel(10L);
        doNothing().when(unit).validateOrderEntry(orderEntryToCancelDto);

        unit.validateRequest();

        verify(unit).validateOrderEntry(orderEntryToCancelDto);
    }

    @Test
    public void shouldValidateRequestWhenCheckboxIsChecked() {
        ListModel<Object> listModelList = new ListModelList<>(Collections.singletonList(orderEntryToCancelDto));
        when(orderEntries.getRows()).thenReturn(rows);
        when(rows.getChildren()).thenReturn(List.of(row));
        when(row.getChildren()).thenReturn(List.of(row, row, row, row, row, cancelQty));
        when(row.isChecked()).thenReturn(Boolean.TRUE);

        when(cancelQty.getRawValue()).thenReturn(1);

        when(orderEntries.getModel()).thenReturn(listModelList);
        orderEntryToCancelDto.setQuantityToCancel(10L);
        doNothing().when(unit).validateOrderEntry(orderEntryToCancelDto);

        unit.validateRequest();

        verify(unit).validateOrderEntry(orderEntryToCancelDto);
    }

    @Test(expected = WrongValueException.class)
    public void shouldNotValidateRequestAndThrowWrongValueExceptionWhenQuantityToCancelZero() {
        ListModel<Object> listModelList = new ListModelList<>(Collections.singletonList(orderEntryToCancelDto));
        when(orderEntries.getRows()).thenReturn(rows);
        when(rows.getChildren()).thenReturn(List.of(row));
        when(row.getChildren()).thenReturn(List.of(row, row, row, row, row, cancelQty));
        when(row.isChecked()).thenReturn(Boolean.TRUE);

        when(cancelQty.getRawValue()).thenReturn(1);

        when(orderEntries.getModel()).thenReturn(listModelList);
        orderEntryToCancelDto.setQuantityToCancel(0L);

        when(widgetInstanceManager.getLabel(CUSTOMERSUPPORTBACKOFFICE_CANCELORDER_MISSING_SELECTED_LINE)).thenReturn(CUSTOMERSUPPORTBACKOFFICE_CANCELORDER_MISSING_SELECTED_LINE);

        unit.validateRequest();

        verify(unit).validateOrderEntry(orderEntryToCancelDto);
    }

    @Test(expected = WrongValueException.class)
    public void shouldNotValidateRequestAndThrowWrongValueExceptionWhenRawValueZero() {
        when(orderEntries.getRows()).thenReturn(rows);
        when(rows.getChildren()).thenReturn(List.of(row));
        when(row.getChildren()).thenReturn(List.of(row, row, row, row, row, cancelQty));
        when(row.isChecked()).thenReturn(Boolean.TRUE);

        when(cancelQty.getRawValue()).thenReturn(0);

        when(widgetInstanceManager.getLabel(CUSTOMERSUPPORTBACKOFFICE_CANCELORDER_MISSING_QUANTITY)).thenReturn(CUSTOMERSUPPORTBACKOFFICE_CANCELORDER_MISSING_QUANTITY);

        unit.validateRequest();

        verify(unit, never()).validateOrderEntry(orderEntryToCancelDto);
    }
}