package com.paypal.hybris.backoffice.render;

import com.hybris.cockpitng.core.config.impl.jaxb.editorarea.AbstractPanel;
import com.hybris.cockpitng.core.model.WidgetModel;
import com.hybris.cockpitng.dataaccess.facades.type.DataType;
import com.hybris.cockpitng.engine.WidgetInstanceManager;
import com.paypal.hybris.core.enums.PayPalColor;
import com.paypal.hybris.core.enums.PayPalLabel;
import com.paypal.hybris.core.enums.PayPalShape;
import com.paypal.hybris.core.model.PayPalStylesConfigurationModel;
import com.paypal.hybris.core.service.PayPalConfigurationService;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.zkoss.zk.ui.Component;

import java.util.List;

import static org.mockito.Mockito.any;
import static org.mockito.Mockito.doNothing;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class PayPalStylesCustomRendererTest {

    private static final String CURRENT_OBJECT_DOTLESS = "currentObject";
    public static final String CLIENT_ID = "clientId";

    @Mock
    private PayPalConfigurationService payPalConfigurationService;

    @Mock
    private Component component;

    @Mock
    private Component childComponent;

    @Mock
    private AbstractPanel abstractPanel;

    @Mock
    private PayPalStylesConfigurationModel payPalStylesConfigurationModel;

    @Mock
    private DataType dataType;

    @Mock
    private WidgetModel widgetModel;

    @Mock
    private WidgetInstanceManager widgetInstanceManager;

    @Mock
    private List<Component> children;

    @InjectMocks
    private PayPalStylesCustomRenderer unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldRenderPayPalButton() {
        when(payPalConfigurationService.getClientID()).thenReturn(CLIENT_ID);
        when(payPalStylesConfigurationModel.getBorderRadius()).thenReturn(12);
        when(payPalStylesConfigurationModel.getHeight()).thenReturn(20);
        when(payPalStylesConfigurationModel.getColor()).thenReturn(PayPalColor.BLACK);
        when(payPalStylesConfigurationModel.getShape()).thenReturn(PayPalShape.PILL);
        when(payPalStylesConfigurationModel.getLabel()).thenReturn(PayPalLabel.PAYPAL);

        when(widgetInstanceManager.getModel()).thenReturn(widgetModel);

        unit.render(component, abstractPanel, payPalStylesConfigurationModel, dataType, widgetInstanceManager);

        verify(component, times(4)).appendChild(any());
    }

    @Test
    public void shouldUpdateButtonWhenValueChanged() {
        when(widgetModel.getValue(CURRENT_OBJECT_DOTLESS, PayPalStylesConfigurationModel.class)).thenReturn(payPalStylesConfigurationModel);
        when(component.getChildren()).thenReturn(children);

        doNothing().when(children).clear();

        when(payPalConfigurationService.getClientID()).thenReturn(CLIENT_ID);
        when(payPalStylesConfigurationModel.getHeight()).thenReturn(20);
        when(payPalStylesConfigurationModel.getColor()).thenReturn(PayPalColor.BLACK);
        when(payPalStylesConfigurationModel.getShape()).thenReturn(PayPalShape.PILL);
        when(payPalStylesConfigurationModel.getLabel()).thenReturn(PayPalLabel.PAYPAL);

        unit.onValueChanged(component, widgetModel);

        verify(component, times(4)).appendChild(any());

    }
}