package com.paypal.hybris.backoffice.render;

import com.hybris.backoffice.widgets.notificationarea.event.NotificationEvent;
import com.hybris.cockpitng.util.notifications.NotificationService;
import com.paypal.hybris.core.model.PayPalConfigurationModel;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.order.CartModel;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import static org.mockito.Mockito.any;
import static org.mockito.Mockito.eq;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class PayPalNotificationRendererTest {

    private static final String UPDATE_CONFIG = "UpdateConfig";

    private static final String DEFAULT_UPDATE_OBJECT = "DefaultUpdateObject";
    private static final String GENERAL_CONFIGURATION = "PayPalGeneralConfiguration";
    private static final String PAYPAL_CONFIGURATION = "PayPalConfiguration";
    private static final String VENMO_CONFIGURATION = "VenmoConfiguration";
    private static final String SOURCE = "source";

    @Mock
    private NotificationService notificationService;

    @Mock
    private NotificationEvent notificationEvent;

    @InjectMocks
    private PayPalNotificationRenderer unit;

    private Map<String, Object> map;

    private Set<String> configTypeSet;

    private PayPalConfigurationModel payPalConfigurationModel;

    private CartModel cartModel;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);

        payPalConfigurationModel = new PayPalConfigurationModel();
        cartModel = new CartModel();
        configTypeSet = new HashSet<>();
        configTypeSet.add(GENERAL_CONFIGURATION);
        configTypeSet.add(PAYPAL_CONFIGURATION);
        configTypeSet.add(VENMO_CONFIGURATION);
        unit.setConfigTypeSet(configTypeSet);
    }

    @Test
    public void shouldShowCustomMessage() {
        AbstractList abstractList = new ArrayList();
        abstractList.add(payPalConfigurationModel);
        when(notificationEvent.getReferencedObjects()).thenReturn(new Object[]{abstractList});
        when(notificationEvent.getSource()).thenReturn(SOURCE);

        unit.render(notificationEvent, map);

        verify(notificationService).notifyUser(eq(SOURCE), eq(UPDATE_CONFIG),
                eq(NotificationEvent.Level.SUCCESS), any());
    }

    @Test
    public void shouldShowDefaultMessage() {
        AbstractList abstractList = new ArrayList();
        abstractList.add(cartModel);
        when(notificationEvent.getReferencedObjects()).thenReturn(new Object[]{abstractList});        when(notificationEvent.getSource()).thenReturn(SOURCE);

        unit.render(notificationEvent, map);

        verify(notificationService).notifyUser(eq(SOURCE), eq(DEFAULT_UPDATE_OBJECT),
                eq(NotificationEvent.Level.SUCCESS), any());
    }

}