package com.paypal.hybris.backoffice.render;

import com.hybris.cockpitng.core.config.impl.jaxb.editorarea.AbstractPanel;
import com.hybris.cockpitng.core.model.WidgetModel;
import com.hybris.cockpitng.dataaccess.facades.type.DataType;
import com.hybris.cockpitng.engine.WidgetInstanceManager;
import com.paypal.hybris.core.enums.ApplePayButtonType;
import com.paypal.hybris.core.enums.ApplePayColor;
import com.paypal.hybris.core.model.ApplePayStylesConfigurationModel;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.zkoss.zk.ui.Component;

import java.util.Collections;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class ApplePayPreviewButtonRendererTest {

    private static final String CURRENT_OBJECT_DOTLESS = "currentObject";

    @Mock
    private Component component;

    @Mock
    private Component childComponent;

    @Mock
    private AbstractPanel abstractPanel;

    @Mock
    private ApplePayStylesConfigurationModel applePayStylesConfigurationModel;

    @Mock
    private DataType dataType;

    @Mock
    private WidgetModel widgetModel;

    @Mock
    private WidgetInstanceManager widgetInstanceManager;

    @InjectMocks
    private ApplePayPreviewButtonRenderer unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldRenderApplePayButton() {
        when(applePayStylesConfigurationModel.getButtonColor()).thenReturn(ApplePayColor.BLACK);
        when(applePayStylesConfigurationModel.getButtonType()).thenReturn(ApplePayButtonType.PAY);
        when(widgetInstanceManager.getModel()).thenReturn(widgetModel);

        unit.render(component, abstractPanel, applePayStylesConfigurationModel, dataType, widgetInstanceManager);

        verify(component, times(1)).appendChild(any());
    }

    @Test
    public void shouldUpdateButtonWhenValueChangedWhenCurrentRootNotNull() {
        when(widgetModel.getValue(CURRENT_OBJECT_DOTLESS, ApplePayStylesConfigurationModel.class)).thenReturn(applePayStylesConfigurationModel);
        when(component.getChildren()).thenReturn(Collections.singletonList(childComponent));

        when(applePayStylesConfigurationModel.getButtonColor()).thenReturn(ApplePayColor.BLACK);
        when(applePayStylesConfigurationModel.getButtonType()).thenReturn(ApplePayButtonType.PAY);

        unit.onValueChanged(component, widgetModel);

        verify(component).removeChild(childComponent);
        verify(component).appendChild(any());
    }

    @Test
    public void shouldUpdateButtonWhenValueChangedWhenCurrentRootNull() {
        when(widgetModel.getValue(CURRENT_OBJECT_DOTLESS, ApplePayStylesConfigurationModel.class)).thenReturn(null);

        unit.onValueChanged(component, widgetModel);

        verify(component, never()).removeChild(childComponent);
        verify(component, never()).appendChild(any());
    }
}