package com.paypal.hybris.backoffice.handlers;

import com.hybris.backoffice.widgets.notificationarea.event.NotificationEvent;
import com.hybris.cockpitng.dataaccess.facades.object.ObjectFacade;
import com.hybris.cockpitng.dataaccess.facades.object.exceptions.ObjectSavingException;
import com.hybris.cockpitng.engine.WidgetInstanceManager;
import com.hybris.cockpitng.util.notifications.NotificationService;
import com.paypal.hybris.core.model.PayPalGeneralConfigurationModel;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.PK;
import de.hybris.platform.servicelayer.model.ModelService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import static org.mockito.Mockito.never;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class PayPalGeneralConfigurationEditorAreaLogicHandlerTest {

    private static final String SETTLE_IMMEDIATELY_ENABLED = "settleImmediatelyEnabled";

    @Mock
    private ObjectFacade objectFacade;

    @Mock
    private NotificationService notificationService;

    @Mock
    private WidgetInstanceManager widgetInstanceManager;

    @Mock
    private ModelService modelService;

    @Mock
    private PayPalGeneralConfigurationModel currentObject;

    @Mock
    private PayPalGeneralConfigurationModel originalObject;

    @InjectMocks
    private PayPalGeneralConfigurationEditorAreaLogicHandler unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldShowInfoNotificationWhenSettleImmediatelyDisabled() throws ObjectSavingException {
        when(currentObject.getPk()).thenReturn(PK.BIG_PK);
        when(modelService.get(PK.BIG_PK)).thenReturn(originalObject);

        when(currentObject.isSettleImmediately()).thenReturn(Boolean.FALSE);
        when(originalObject.isSettleImmediately()).thenReturn(Boolean.TRUE);

        unit.performSave(widgetInstanceManager, currentObject);

        verify(notificationService).notifyUser(widgetInstanceManager, SETTLE_IMMEDIATELY_ENABLED, NotificationEvent.Level.INFO);
    }

    @Test
    public void shouldNotShowInfoNotificationWhenSettleImmediatelyJustEnabled() throws ObjectSavingException {
        when(currentObject.getPk()).thenReturn(PK.BIG_PK);
        when(modelService.get(PK.BIG_PK)).thenReturn(originalObject);

        when(currentObject.isSettleImmediately()).thenReturn(Boolean.TRUE);
        when(originalObject.isSettleImmediately()).thenReturn(Boolean.FALSE);

        unit.performSave(widgetInstanceManager, currentObject);

        verify(notificationService, never()).notifyUser(widgetInstanceManager, SETTLE_IMMEDIATELY_ENABLED, NotificationEvent.Level.INFO);
    }

    @Test
    public void shouldNotShowInfoNotificationWhenSettleImmediatelyAlreadyDisabled() throws ObjectSavingException {
        when(currentObject.getPk()).thenReturn(PK.BIG_PK);
        when(modelService.get(PK.BIG_PK)).thenReturn(originalObject);

        when(currentObject.isSettleImmediately()).thenReturn(Boolean.FALSE);
        when(originalObject.isSettleImmediately()).thenReturn(Boolean.FALSE);

        unit.performSave(widgetInstanceManager, currentObject);

        verify(notificationService, never()).notifyUser(widgetInstanceManager, SETTLE_IMMEDIATELY_ENABLED, NotificationEvent.Level.INFO);
    }
}