package com.paypal.hybris.backoffice.handlers;

import com.hybris.backoffice.widgets.notificationarea.event.NotificationEvent;
import com.hybris.cockpitng.dataaccess.facades.object.ObjectFacade;
import com.hybris.cockpitng.dataaccess.facades.object.exceptions.ObjectSavingException;
import com.hybris.cockpitng.engine.WidgetInstanceManager;
import com.hybris.cockpitng.util.notifications.NotificationService;
import com.paypal.hybris.core.model.ApplePayConfigurationModel;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import static org.mockito.Mockito.never;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class ApplePayConfigurationEditorAreaLogicHandlerTest {

    private static final String APPLE_PAY_CONFIGURATION_DISABLED = "applePayConfigurationDisabled";

    @Mock
    private ObjectFacade objectFacade;

    @Mock
    private NotificationService notificationService;

    @Mock
    private WidgetInstanceManager widgetInstanceManager;

    @Mock
    private ApplePayConfigurationModel currentObject;

    @InjectMocks
    private ApplePayConfigurationEditorAreaLogicHandler unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldShowInfoNotificationWhenApplePayDisabled() throws ObjectSavingException {
        when(currentObject.isEnable()).thenReturn(Boolean.FALSE);

        unit.performSave(widgetInstanceManager, currentObject);

        verify(notificationService).notifyUser(widgetInstanceManager, APPLE_PAY_CONFIGURATION_DISABLED, NotificationEvent.Level.INFO);
    }

    @Test
    public void shouldNotShowInfoNotificationWhenApplePayEnabled() throws ObjectSavingException {
        when(currentObject.isEnable()).thenReturn(Boolean.TRUE);

        unit.performSave(widgetInstanceManager, currentObject);

        verify(notificationService, never()).notifyUser(widgetInstanceManager, APPLE_PAY_CONFIGURATION_DISABLED, NotificationEvent.Level.INFO);
    }

    @Test
    public void shouldShowWarningNotificationWhenApplePayDisabled() {
        when(currentObject.isEnable()).thenReturn(Boolean.FALSE);

        unit.beforeEditorAreaRender(widgetInstanceManager, currentObject);

        verify(notificationService).notifyUser(widgetInstanceManager, APPLE_PAY_CONFIGURATION_DISABLED, NotificationEvent.Level.WARNING);
    }

    @Test
    public void shouldNotShowWarningNotificationWhenApplePayEnabled() {
        when(currentObject.isEnable()).thenReturn(Boolean.TRUE);

        unit.beforeEditorAreaRender(widgetInstanceManager, currentObject);

        verify(notificationService, never()).notifyUser(widgetInstanceManager, APPLE_PAY_CONFIGURATION_DISABLED, NotificationEvent.Level.WARNING);
    }
}