package com.paypal.hybris.backoffice.editors.paypalconfiguration;

import com.hybris.cockpitng.editors.EditorContext;
import com.hybris.cockpitng.editors.EditorListener;
import com.paypal.hybris.core.model.PayPalConfigurationModel;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ext.Disable;
import org.zkoss.zul.Combobox;

import static org.mockito.Mockito.doNothing;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class PayPalConfigurationStringEditorTest {

    private static final String PARENT_OBJECT = "parentObject";

    @Mock
    private Component parent;

    @Mock
    private EditorContext<String> editorContext;

    @Mock
    private EditorListener<String> listener;

    @Mock
    private Combobox disable;

    @Mock
    private PayPalConfigurationModel payPalConfigurationModel;

    @Spy
    @InjectMocks
    private PayPalConfigurationStringEditor unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldDisablePropertyWhenPayPalDisabled() {
        doNothing().when(unit).preRender(parent, editorContext, listener);

        when(editorContext.getParameter(PARENT_OBJECT)).thenReturn(payPalConfigurationModel);
        when(payPalConfigurationModel.isPayPalEnable()).thenReturn(Boolean.FALSE);
        when(parent.getFirstChild()).thenReturn(disable);

        unit.render(parent, editorContext, listener);

        verify((Disable) disable).setDisabled(Boolean.TRUE);
    }

    @Test
    public void shouldNotDisablePropertyWhenHostedFieldsEnabled() {
        doNothing().when(unit).preRender(parent, editorContext, listener);

        when(editorContext.getParameter(PARENT_OBJECT)).thenReturn(payPalConfigurationModel);
        when(payPalConfigurationModel.isPayPalEnable()).thenReturn(Boolean.TRUE);

        unit.render(parent, editorContext, listener);

        verify((Disable) disable, never()).setDisabled(Boolean.TRUE);
    }

}