package com.paypal.hybris.backoffice.editors.paypalconfiguration;

import com.hybris.cockpitng.editors.EditorContext;
import com.hybris.cockpitng.editors.EditorListener;
import com.paypal.hybris.core.model.PayPalConfigurationModel;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Div;

import java.util.List;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.doNothing;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;


@UnitTest
public class PayPalConfigurationLocalizedStringEditorTest {

    private static final String PARENT_OBJECT = "parentObject";

    @Mock
    private Component parent;

    @Mock
    private EditorContext editorContext;

    @Mock
    private EditorListener listener;

    @Mock
    private PayPalConfigurationModel payPalConfigurationModel;

    @Mock
    private Div div;

    @Spy
    @InjectMocks
    private PayPalConfigurationLocalizedStringEditor unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldDisablePropertyWhenPayPalDisabled() {
        doNothing().when(unit).preRender(parent, editorContext, listener);

        when(editorContext.getParameter(PARENT_OBJECT)).thenReturn(payPalConfigurationModel);
        when(payPalConfigurationModel.isPayPalEnable()).thenReturn(Boolean.FALSE);
        when(parent.getFirstChild()).thenReturn(div);
        when(div.getChildren()).thenReturn(List.of(div, div));

        unit.render(parent, editorContext, listener);

        verify(div, times(2)).setSclass(any());
    }

    @Test
    public void shouldNotDisablePropertyWhenPayPalEnabled() {
        doNothing().when(unit).preRender(parent, editorContext, listener);

        when(editorContext.getParameter(PARENT_OBJECT)).thenReturn(payPalConfigurationModel);
        when(payPalConfigurationModel.isPayPalEnable()).thenReturn(Boolean.TRUE);

        unit.render(parent, editorContext, listener);

        verify(div, never()).setSclass(any());
    }
}