package com.paypal.hybris.backoffice.editors.localpaymentsconfiguration;

import com.hybris.cockpitng.editors.EditorContext;
import com.hybris.cockpitng.editors.EditorListener;
import com.paypal.hybris.core.enums.LocalPaymentFunding;
import com.paypal.hybris.core.model.LocalPaymentsConfigurationModel;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Div;

import java.util.Collection;
import java.util.List;

import static org.mockito.Mockito.any;
import static org.mockito.Mockito.doNothing;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class LocalPaymentsConfigurationEnumListEditorTest {

    private static final String PARENT_OBJECT = "parentObject";

    @Mock
    private Component parent;

    @Mock
    private EditorContext<Collection<LocalPaymentFunding>> editorContext;

    @Mock
    private EditorListener<Collection<LocalPaymentFunding>> listener;

    @Mock
    private LocalPaymentsConfigurationModel localPaymentsConfigurationModel;

    @Mock
    private Div div;

    @Spy
    @InjectMocks
    private LocalPaymentsConfigurationEnumListEditor unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldDisablePropertyWhenLocalPaymentsDisabled() {
        doNothing().when(unit).preRender(parent, editorContext, listener);

        when(editorContext.getParameter(PARENT_OBJECT)).thenReturn(localPaymentsConfigurationModel);
        when(localPaymentsConfigurationModel.isEnable()).thenReturn(Boolean.FALSE);
        when(parent.getFirstChild()).thenReturn(div);
        when(div.getChildren()).thenReturn(List.of(div));

        unit.render(parent, editorContext, listener);

        verify(div).setSclass(any());
    }

    @Test
    public void shouldNotDisablePropertyWhenLocalPaymentsEnabled() {
        doNothing().when(unit).preRender(parent, editorContext, listener);

        when(editorContext.getParameter(PARENT_OBJECT)).thenReturn(localPaymentsConfigurationModel);
        when(localPaymentsConfigurationModel.isEnable()).thenReturn(Boolean.TRUE);

        unit.render(parent, editorContext, listener);

        verify(div, never()).setSclass(any());
    }

}