package com.paypal.hybris.backoffice.editors.hostedfieldsconfigutation;

import com.hybris.cockpitng.editors.EditorContext;
import com.hybris.cockpitng.editors.EditorListener;
import com.paypal.hybris.core.model.HostedFieldsConfigurationModel;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ext.Disable;
import org.zkoss.zul.Combobox;

import static org.mockito.Mockito.doNothing;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class HostedFieldsConfigurationSavedCreditCardsLimitEditorTest {

    private static final String PARENT_OBJECT = "parentObject";

    @Mock
    private Component parent;

    @Mock
    private EditorContext<Object> editorContext;

    @Mock
    private EditorListener<Object> listener;

    @Mock
    private Combobox disable;

    @Mock
    private HostedFieldsConfigurationModel hostedFieldsConfigurationModel;

    @Spy
    @InjectMocks
    private HostedFieldsConfigurationSavedCreditCardsLimitEditor unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldDisablePropertyWhenHostedFieldsDisabled() {
        doNothing().when(unit).preRender(parent, editorContext, listener);

        when(editorContext.getParameter(PARENT_OBJECT)).thenReturn(hostedFieldsConfigurationModel);
        when(hostedFieldsConfigurationModel.isEnable()).thenReturn(Boolean.FALSE);
        when(hostedFieldsConfigurationModel.isVaultFlow()).thenReturn(Boolean.TRUE);
        when(parent.getFirstChild()).thenReturn(disable);

        unit.render(parent, editorContext, listener);

        verify((Disable) disable).setDisabled(Boolean.TRUE);
    }

    @Test
    public void shouldDisablePropertyWhenVaultFlowDisabled() {
        doNothing().when(unit).preRender(parent, editorContext, listener);

        when(editorContext.getParameter(PARENT_OBJECT)).thenReturn(hostedFieldsConfigurationModel);
        when(hostedFieldsConfigurationModel.isEnable()).thenReturn(Boolean.TRUE);
        when(hostedFieldsConfigurationModel.isVaultFlow()).thenReturn(Boolean.FALSE);
        when(parent.getFirstChild()).thenReturn(disable);

        unit.render(parent, editorContext, listener);

        verify((Disable) disable).setDisabled(Boolean.TRUE);
    }


    @Test
    public void shouldNotDisablePropertyWhenHostedFieldsAndVaultFlowEnabled() {
        doNothing().when(unit).preRender(parent, editorContext, listener);

        when(editorContext.getParameter(PARENT_OBJECT)).thenReturn(hostedFieldsConfigurationModel);
        when(hostedFieldsConfigurationModel.isEnable()).thenReturn(Boolean.TRUE);
        when(hostedFieldsConfigurationModel.isVaultFlow()).thenReturn(Boolean.TRUE);

        unit.render(parent, editorContext, listener);

        verify((Disable) disable, never()).setDisabled(Boolean.TRUE);
    }
}