package com.paypal.hybris.backoffice.editors.hostedfieldsconfigutation;

import com.hybris.cockpitng.components.Editor;
import com.hybris.cockpitng.editors.EditorContext;
import com.hybris.cockpitng.editors.EditorListener;
import com.paypal.hybris.core.model.HostedFieldsConfigurationModel;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.zkoss.zul.Div;
import org.zkoss.zul.Radiogroup;

import java.util.List;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.doNothing;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class HostedFieldsConfigurationBooleanEditorTest {

    private static final String PARENT_OBJECT = "parentObject";

    @Mock
    private Editor parent;

    @Mock
    private EditorContext<Boolean> editorContext;

    @Mock
    private EditorListener<Boolean> listener;

    @Mock
    private Radiogroup radiogroup;

    @Mock
    private Div div;

    @Mock
    private HostedFieldsConfigurationModel hostedFieldsConfigurationModel;

    @Spy
    @InjectMocks
    private HostedFieldsConfigurationBooleanEditor unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldDisablePropertyWhenHostedFieldsDisabled() {
        doNothing().when(unit).preRender(parent, editorContext, listener);

        when(editorContext.getParameter(PARENT_OBJECT)).thenReturn(hostedFieldsConfigurationModel);
        when(hostedFieldsConfigurationModel.isEnable()).thenReturn(Boolean.FALSE);
        when(parent.getFirstChild()).thenReturn(radiogroup);
        when(radiogroup.getChildren()).thenReturn(List.of(div));

        unit.render(parent, editorContext, listener);

        verify(div).setSclass(any());
    }

    @Test
    public void shouldNotDisablePropertyWhenHostedFieldsEnabled() {
        doNothing().when(unit).preRender(parent, editorContext, listener);

        when(editorContext.getParameter(PARENT_OBJECT)).thenReturn(hostedFieldsConfigurationModel);
        when(hostedFieldsConfigurationModel.isEnable()).thenReturn(Boolean.TRUE);

        unit.render(parent, editorContext, listener);

        verify(div, never()).setSclass(any());
    }
}