package com.paypal.hybris.backoffice.action.order.capture;

import com.hybris.cockpitng.actions.ActionContext;
import com.hybris.cockpitng.actions.ActionResult;
import com.hybris.cockpitng.engine.impl.ComponentWidgetAdapter;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.enums.OrderStatus;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.payment.model.PaymentTransactionEntryModel;
import de.hybris.platform.payment.model.PaymentTransactionModel;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;

import java.util.Collections;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class PayPalCaptureActionTest {

    private static final String SOCKET_OUT_CONTEXT = "paypalCaptureContext";

    private static final String ACCEPTED_STATUS = "ACCEPTED";

    private static final String REJECTED_STATUS = "REJECTED";

    @Mock
    private ComponentWidgetAdapter componentWidgetAdapter;

    @Mock
    private ActionContext<OrderModel> actionContext;

    @Mock
    private OrderModel orderModel;

    @Mock
    private PaymentTransactionModel transactionModel;

    @Mock
    private PaymentTransactionEntryModel transactionEntryModel;

    @Spy
    @InjectMocks
    private PayPalCaptureAction unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldReturnSuccessActionCode() {
        when(actionContext.getData()).thenReturn(orderModel);

        assertEquals(ActionResult.SUCCESS, unit.perform(actionContext).getResultCode());
        verify(unit).sendOutput(SOCKET_OUT_CONTEXT, orderModel);
    }

    @Test
    public void shouldReturnTrue() {
        when(actionContext.getData()).thenReturn(orderModel);
        when(orderModel.getStatus()).thenReturn(OrderStatus.PAYMENT_NOT_CAPTURED);
        when(orderModel.getPaymentTransactions()).thenReturn(Collections.singletonList(transactionModel));
        when(transactionModel.getEntries()).thenReturn(Collections.singletonList(transactionEntryModel));
        when(transactionEntryModel.getTransactionStatus()).thenReturn(ACCEPTED_STATUS);

        assertTrue(unit.canPerform(actionContext));
    }

    @Test
    public void shouldReturnFalseWhenOrderNull() {
        when(actionContext.getData()).thenReturn(null);

        assertFalse(unit.canPerform(actionContext));
    }

    @Test
    public void shouldReturnFalseWhenOrderStatusRejected() {
        when(actionContext.getData()).thenReturn(orderModel);
        when(orderModel.getStatus()).thenReturn(OrderStatus.REJECTED);

        assertFalse(unit.canPerform(actionContext));
    }

    @Test
    public void shouldReturnFalseWhenOrderHasNotUncancelledTransactions() {
        when(actionContext.getData()).thenReturn(orderModel);
        when(orderModel.getStatus()).thenReturn(OrderStatus.PAYMENT_NOT_CAPTURED);
        when(orderModel.getPaymentTransactions()).thenReturn(Collections.singletonList(transactionModel));
        when(transactionModel.getEntries()).thenReturn(Collections.singletonList(transactionEntryModel));
        when(transactionEntryModel.getTransactionStatus()).thenReturn(REJECTED_STATUS);

        assertFalse(unit.canPerform(actionContext));
    }

    @Test
    public void shouldReturnFalseWhenNeedsConfirmation() {
        assertFalse(unit.needsConfirmation(actionContext));
    }

    @Test
    public void shouldReturnNullWhenGetConfirmationMessage() {
        assertNull(unit.getConfirmationMessage(actionContext));
    }
}