package com.paypal.hybris.backoffice.util;

import de.hybris.platform.basecommerce.enums.ConsignmentStatus;
import de.hybris.platform.ordersplitting.model.ConsignmentModel;
import de.hybris.platform.payment.dto.TransactionStatus;
import de.hybris.platform.payment.enums.PaymentTransactionType;
import de.hybris.platform.payment.model.PaymentTransactionEntryModel;
import de.hybris.platform.payment.model.PaymentTransactionModel;
import org.apache.commons.lang.StringUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.function.Predicate;

public class PayPalBackofficeUtil {

    private PayPalBackofficeUtil() {
    }

    public static BigDecimal calculateCapturedAmount(List<PaymentTransactionModel> transactions) {
        Predicate<PaymentTransactionEntryModel> capturedPredicate = entry ->
                (PaymentTransactionType.PARTIAL_CAPTURE.equals(entry.getType()) || PaymentTransactionType.CAPTURE
                        .equals(entry.getType()))
                        && TransactionStatus.ACCEPTED.name().equals(entry.getTransactionStatus());

        return transactions.stream().flatMap(transaction -> transaction.getEntries().stream())
                .filter(capturedPredicate).map(PaymentTransactionEntryModel::getAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static BigDecimal calculateTransactionsPlanedAmount(List<PaymentTransactionModel> transactions) {
        return transactions.stream().map(PaymentTransactionModel::getPlannedAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static BigDecimal calculateAuthorizedAmount(List<PaymentTransactionModel> transactions) {
        Predicate<PaymentTransactionEntryModel> authorizationEntries = (entry -> (PaymentTransactionType.AUTHORIZATION
                .equals(entry.getType())) && TransactionStatus.ACCEPTED.name().equals(entry.getTransactionStatus()));

        return transactions.stream().flatMap(transaction -> transaction.getEntries().stream())
                .filter(authorizationEntries).map(PaymentTransactionEntryModel::getAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static boolean hasShippedNotTrackedConsignments(ConsignmentModel consignment) {
        return consignment != null
                && ConsignmentStatus.SHIPPED.equals(consignment.getStatus())
                && (StringUtils.isEmpty(consignment.getTrackingID()) || StringUtils.isEmpty(consignment.getCarrier()));
    }

}
