package com.paypal.hybris.backoffice.render;

import com.hybris.cockpitng.core.config.impl.jaxb.editorarea.AbstractPanel;
import com.hybris.cockpitng.core.model.ModelObserver;
import com.hybris.cockpitng.core.model.WidgetModel;
import com.hybris.cockpitng.dataaccess.facades.type.DataType;
import com.hybris.cockpitng.engine.WidgetInstanceManager;
import com.hybris.cockpitng.widgets.editorarea.renderer.impl.AbstractEditorAreaPanelRenderer;
import com.paypal.hybris.core.model.PayPalStylesConfigurationModel;
import com.paypal.hybris.core.service.PayPalConfigurationService;
import org.apache.commons.lang.StringUtils;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zul.Div;
import org.zkoss.zul.Html;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.Script;

public class PayPalStylesCustomRenderer extends AbstractEditorAreaPanelRenderer<PayPalStylesConfigurationModel> {

    private static final String VALUE_CHANGED = "$_value_changed";
    private static final String RENDER_PAY_PAL_BUTTON_JS_FUNCTION_CALL = "setTimeout(renderPayPalButton, 1000)";
    private static final String PAYPAL_PREVIEW_BUTTON_IFRAME_CLASS = "paypal-preview-button-iframe";
    private static final String OVERLAY_PAYPAL_BUTTONS_STYLE = "position: absolute; top: 0; bottom: 0; left: 0; right: 0; background: transparent;";
    private static final String RENDER_PAYPAL_BUTTONS_SCRIPT = "var div = document.createElement('div');div.id = 'paypal-button-cnt';" +
            "if (window.self !== window.top) {document.body.appendChild(div);} else " +
            "{document.getElementsByClassName('paypal-preview-button-iframe')[0]" +
            ".contentDocument.getElementsByTagName('body')[0].appendChild(div);}" +
            "paypal.Buttons({fundingSource: 'paypal', style: {disableMaxWidth: true, color:  '%s', shape:  '%s', label:  '%s',height: %d, %s }}).render(div);";

    private PayPalConfigurationService payPalConfigurationService;

    @Override
    public void render(Component component, AbstractPanel abstractPanel, PayPalStylesConfigurationModel payPalStylesConfigurationModel, DataType dataType, WidgetInstanceManager widgetInstanceManager) {
        addPayPalButtonPreviewToComponent(component, payPalStylesConfigurationModel);

        WidgetModel model = widgetInstanceManager.getModel();
        model.addObserver(VALUE_CHANGED, (ModelObserver) () -> onValueChanged(component, model));
    }

    protected void onValueChanged(Component component, WidgetModel model) {
        PayPalStylesConfigurationModel currentRoot =
                model.getValue(CURRENT_OBJECT_DOTLESS, PayPalStylesConfigurationModel.class);
        Components.removeAllChildren(component);
        addPayPalButtonPreviewToComponent(component, currentRoot);
    }

    private void addPayPalButtonPreviewToComponent(Component component, PayPalStylesConfigurationModel payPalStylesConfigurationModel) {
        Iframe iframe = new Iframe();
        iframe.setVflex(Boolean.TRUE.toString());
        iframe.setClass(PAYPAL_PREVIEW_BUTTON_IFRAME_CLASS);

        Script script = new Script(RENDER_PAY_PAL_BUTTON_JS_FUNCTION_CALL);
        script.setDefer(true);

        component.appendChild(iframe);
        component.appendChild(getPayPalButtons(payPalStylesConfigurationModel));
        component.appendChild(getOverlayForPayPalButtons());
        component.appendChild(script);
    }

    private String getButtonColorStyle(PayPalStylesConfigurationModel payPalStylesConfigurationModel) {
        return payPalStylesConfigurationModel.getColor().toString().toLowerCase();
    }

    private Div getOverlayForPayPalButtons() {
        Div overlay = new Div();
        overlay.setStyle(OVERLAY_PAYPAL_BUTTONS_STYLE);
        return overlay;
    }

    private String getButtonShapeStyle(PayPalStylesConfigurationModel payPalStylesConfigurationModel) {
        return payPalStylesConfigurationModel.getShape().toString().toLowerCase();
    }

    private Html getPayPalButtons(PayPalStylesConfigurationModel model) {
        String clientID = payPalConfigurationService.getClientID();

        String loadScriptFunction = "function loadScript(src) {" +
                "  return new Promise(function(resolve, reject) {" +
                "    const script = document.createElement('script');" +
                "    script.type = 'text/javascript';" +
                "    script.src = src;" +
                "    script.async = true;" +
                "    script.id = 'paypalApi';" +
                "    script.onerror = function(err) {" +
                "      reject(err, script);" +
                "    };" +
                "    script.onload = script.onreadystatechange = function() {" +
                "      if (!this.readyState || this.readyState == 'complete') {" +
                "        resolve();" +
                "      }" +
                "    };" +
                "    document.body.appendChild(script);" +
                "  });" +
                "}";

        String renderButtonScript = "<script> function renderPayPalButton() {" +
                "$('.paypal-preview-button-iframe').contents().find('body').append(\"<script>" + loadScriptFunction +
                "loadScript('https://www.paypal.com/sdk/js?client-id=" + clientID + "').then((data) => { " + getPayPalButton(model) +
                "});<\\/script>\")} </script>";
        return new Html(renderButtonScript);
    }

    private String getPayPalButton(PayPalStylesConfigurationModel model) {
        int borderRadius = model.getBorderRadius();
        String borderRadiusStyle = borderRadius != 0 ? String.format("borderRadius: %d", borderRadius) : StringUtils.EMPTY;
        return String.format(RENDER_PAYPAL_BUTTONS_SCRIPT,
                getButtonColorStyle(model), getButtonShapeStyle(model), getButtonLabel(model), model.getHeight(), borderRadiusStyle);
    }

    private String getButtonLabel(PayPalStylesConfigurationModel model) {
        return model.getLabel().toString().toLowerCase();
    }

    public void setPayPalConfigurationService(PayPalConfigurationService payPalConfigurationService) {
        this.payPalConfigurationService = payPalConfigurationService;
    }
}
