package com.paypal.hybris.backoffice.render;

import com.hybris.backoffice.widgets.notificationarea.NotificationRenderer;
import com.hybris.backoffice.widgets.notificationarea.event.NotificationEvent;
import com.hybris.cockpitng.util.notifications.NotificationService;
import de.hybris.platform.core.model.ItemModel;
import org.zkoss.zk.ui.Component;

import java.util.AbstractList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class PayPalNotificationRenderer implements NotificationRenderer {

    private static final String UPDATE_CONFIG = "UpdateConfig";

    private static final String DEFAULT_UPDATE_OBJECT = "DefaultUpdateObject";

    private NotificationService notificationService;

    private Set<String> configTypeSet;

    @Override
    public Component render(NotificationEvent notificationEvent, Map<String, Object> map) {
        Optional<ItemModel> item = Optional.ofNullable((ItemModel)((AbstractList)notificationEvent.getReferencedObjects()[0]).get(0));

        if (isSavedObjectPluginConfiguration(item)) {
            notificationService.notifyUser(notificationEvent.getSource(), UPDATE_CONFIG,
                    NotificationEvent.Level.SUCCESS, notificationEvent.getReferencedObjects()[0]);
        } else {
            notificationService.notifyUser(notificationEvent.getSource(), DEFAULT_UPDATE_OBJECT,
                    NotificationEvent.Level.SUCCESS, notificationEvent.getReferencedObjects()[0]);
        }

        return null;
    }

    private boolean isSavedObjectPluginConfiguration(Optional<ItemModel> item) {
        return item.filter(i -> configTypeSet.contains(i.getItemtype())).isPresent();
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void setConfigTypeSet(Set<String> configTypeSet) {
        this.configTypeSet = configTypeSet;
    }
}
