package com.paypal.hybris.backoffice.render;

import com.hybris.cockpitng.core.config.impl.jaxb.editorarea.AbstractPanel;
import com.hybris.cockpitng.core.model.ModelObserver;
import com.hybris.cockpitng.core.model.WidgetModel;
import com.hybris.cockpitng.dataaccess.facades.type.DataType;
import com.hybris.cockpitng.engine.WidgetInstanceManager;
import com.hybris.cockpitng.widgets.editorarea.renderer.impl.AbstractEditorAreaPanelRenderer;
import com.paypal.hybris.core.model.ApplePayStylesConfigurationModel;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Html;

import static com.hybris.backoffice.workflow.designer.handler.WorkflowDesignerCloseListener.VALUE_CHANGED;
import static java.util.Objects.nonNull;

public class ApplePayPreviewButtonRenderer extends
        AbstractEditorAreaPanelRenderer<ApplePayStylesConfigurationModel> {

    private static final String APPLE_PAY_BTN = "<apple-pay-button buttonstyle='%s' type='%s' " +
            "locale='en-US'></apple-pay-button>";

    @Override
    public void render(Component component, AbstractPanel abstractPanel,
                       ApplePayStylesConfigurationModel applePayStylesConfigurationModel,
                       DataType dataType, WidgetInstanceManager widgetInstanceManager) {

        Html applePayButtonHtml = getApplePayButtonHtml(applePayStylesConfigurationModel);
        component.appendChild(applePayButtonHtml);

        WidgetModel model = widgetInstanceManager.getModel();

        model.addObserver(VALUE_CHANGED, (ModelObserver) () -> onValueChanged(component, model));

    }

    protected void onValueChanged(Component component, WidgetModel model) {
        ApplePayStylesConfigurationModel currentRoot =
                model.getValue(CURRENT_OBJECT_DOTLESS, ApplePayStylesConfigurationModel.class);
        if (nonNull(currentRoot)) {
            component.getChildren().forEach(component::removeChild);
            Html updatedApplePayButtonHtml = getApplePayButtonHtml(currentRoot);
            component.appendChild(updatedApplePayButtonHtml);
        }
    }

    private Html getApplePayButtonHtml(ApplePayStylesConfigurationModel applePayStylesConfigurationModel) {
        Html applePayButtonHtml = new Html(String.format(APPLE_PAY_BTN,
                formatConfigurationParam(applePayStylesConfigurationModel.getButtonColor().name()),
                formatConfigurationParam(applePayStylesConfigurationModel.getButtonType().name())));
        return applePayButtonHtml;
    }

    private String formatConfigurationParam(String param) {
        return param.replaceAll("_", "-").toLowerCase();
    }

}
