package com.paypal.hybris.backoffice.handlers;

import com.hybris.backoffice.editorarea.BackofficeEditorAreaLogicHandler;
import com.hybris.backoffice.widgets.notificationarea.event.NotificationEvent;
import com.hybris.cockpitng.dataaccess.facades.object.exceptions.ObjectSavingException;
import com.hybris.cockpitng.engine.WidgetInstanceManager;
import com.hybris.cockpitng.util.notifications.NotificationService;
import com.paypal.hybris.core.model.PayPalGeneralConfigurationModel;
import de.hybris.platform.servicelayer.model.ModelService;

public class PayPalGeneralConfigurationEditorAreaLogicHandler extends BackofficeEditorAreaLogicHandler {

    private static final String SETTLE_IMMEDIATELY_ENABLED = "settleImmediatelyEnabled";

    private NotificationService notificationService;

    private ModelService modelService;

    @Override
    public Object performSave(WidgetInstanceManager widgetInstanceManager, Object currentObject) throws ObjectSavingException {
        PayPalGeneralConfigurationModel currentConfiguration = (PayPalGeneralConfigurationModel) currentObject;
        if (isSettleImmediatelyDisabled(currentConfiguration)) {
            notificationService.notifyUser(widgetInstanceManager, SETTLE_IMMEDIATELY_ENABLED,
                    NotificationEvent.Level.INFO);
        }
        return super.performSave(widgetInstanceManager, currentObject);
    }

    private boolean isSettleImmediatelyDisabled(PayPalGeneralConfigurationModel currentConfiguration) {
        PayPalGeneralConfigurationModel originalConfiguration = modelService.get(currentConfiguration.getPk());
        return !currentConfiguration.isSettleImmediately() && originalConfiguration.isSettleImmediately();
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void setModelService(ModelService modelService) {
        this.modelService = modelService;
    }
}