package com.paypal.hybris.backoffice.handlers;

import com.hybris.backoffice.editorarea.BackofficeEditorAreaLogicHandler;
import com.hybris.backoffice.widgets.notificationarea.event.NotificationEvent;
import com.hybris.cockpitng.dataaccess.facades.object.exceptions.ObjectSavingException;
import com.hybris.cockpitng.engine.WidgetInstanceManager;
import com.hybris.cockpitng.util.notifications.NotificationService;
import com.paypal.hybris.core.enums.SavedPaymentMethodsLimit;
import com.paypal.hybris.core.model.PayPalConfigurationModel;
import de.hybris.platform.servicelayer.session.SessionService;

public class PayPalConfigurationEditorAreaLogicHandler extends BackofficeEditorAreaLogicHandler {

    private static final String PAYPAL_CONFIGURATION_DISABLED = "payPalConfigurationDisabled";
    private static final String PAYPAL_SAVED_ACCOUNTS_LIMIT_CONFIGURATION_MORE_THAN_ONE =
            "payPalSavedAccountsLimitConfigurationMoreThanOne";
    private static final String PAYPAL_SAVED_ACCOUNTS_LIMIT_CONFIGURATION_MORE_THAN_ONE_POPUP =
            "payPalSavedAccountsLimitConfigurationMoreThanOnePopup";
    private static final String SAVED_PAY_PAL_ACCOUNTS_LIMIT_VALUE_BEFORE = "savedPayPalAccountsLimitBefore";

    private NotificationService notificationService;

    private SessionService sessionService;

    @Override
    public Object performSave(WidgetInstanceManager widgetInstanceManager, Object currentObject) throws ObjectSavingException {
        PayPalConfigurationModel currentConfiguration = (PayPalConfigurationModel) currentObject;
        SavedPaymentMethodsLimit savedPayPalAccountsLimitBefore =
                sessionService.getCurrentSession().getAttribute(SAVED_PAY_PAL_ACCOUNTS_LIMIT_VALUE_BEFORE);

        if (!currentConfiguration.isPayPalEnable()) {
            notificationService.notifyUser(widgetInstanceManager, PAYPAL_CONFIGURATION_DISABLED,
                    NotificationEvent.Level.INFO);
        } else if (isPayPalAccountsLimitWasChangedForMoreThanOne(currentConfiguration, savedPayPalAccountsLimitBefore)) {
            notificationService.notifyUser(widgetInstanceManager,
                    PAYPAL_SAVED_ACCOUNTS_LIMIT_CONFIGURATION_MORE_THAN_ONE,
                    NotificationEvent.Level.INFO);
        }

        return super.performSave(widgetInstanceManager, currentObject);
    }

    private static boolean isPayPalAccountsLimitWasChangedForMoreThanOne(PayPalConfigurationModel currentConfiguration,
                                      SavedPaymentMethodsLimit savedPayPalAccountsLimitBefore) {
        if (savedPayPalAccountsLimitBefore != null &&
                savedPayPalAccountsLimitBefore.equals(SavedPaymentMethodsLimit.ONE)) {
            return !currentConfiguration.getSavedPayPalAccountsLimit().equals(SavedPaymentMethodsLimit.ONE);
        }
        return false;
    }

    @Override
    public void beforeEditorAreaRender(WidgetInstanceManager widgetInstanceManager, Object currentObject) {
        PayPalConfigurationModel payPalConfigurationModel = (PayPalConfigurationModel) currentObject;
        if (!payPalConfigurationModel.isPayPalEnable()) {
            notificationService.notifyUser(widgetInstanceManager, PAYPAL_CONFIGURATION_DISABLED,
                    NotificationEvent.Level.WARNING);
        } else if (!payPalConfigurationModel.getSavedPayPalAccountsLimit().equals(SavedPaymentMethodsLimit.ONE)) {
            notificationService.notifyUser(widgetInstanceManager,
                    PAYPAL_SAVED_ACCOUNTS_LIMIT_CONFIGURATION_MORE_THAN_ONE_POPUP, NotificationEvent.Level.WARNING);
        }

        sessionService.getCurrentSession().setAttribute(SAVED_PAY_PAL_ACCOUNTS_LIMIT_VALUE_BEFORE,
                payPalConfigurationModel.getSavedPayPalAccountsLimit());

        super.beforeEditorAreaRender(widgetInstanceManager, currentObject);
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void setSessionService(SessionService sessionService) {
        this.sessionService = sessionService;
    }

}
