package com.paypal.hybris.backoffice.handlers;

import com.hybris.backoffice.editorarea.BackofficeEditorAreaLogicHandler;
import com.hybris.backoffice.widgets.notificationarea.event.NotificationEvent;
import com.hybris.cockpitng.dataaccess.facades.object.exceptions.ObjectSavingException;
import com.hybris.cockpitng.engine.WidgetInstanceManager;
import com.hybris.cockpitng.util.notifications.NotificationService;
import com.paypal.hybris.core.model.LocalPaymentsConfigurationModel;

public class LocalPaymentsConfigurationEditorAreaLogicHandler extends BackofficeEditorAreaLogicHandler {

    private static final String LOCAL_PAYMENTS_CONFIGURATION_DISABLED = "localPaymentsConfigurationDisabled";

    private NotificationService notificationService;

    @Override
    public Object performSave(WidgetInstanceManager widgetInstanceManager, Object currentObject) throws ObjectSavingException {
        LocalPaymentsConfigurationModel localPaymentsConfigurationModel = (LocalPaymentsConfigurationModel) currentObject;
        if (!localPaymentsConfigurationModel.isEnable()) {
            notificationService.notifyUser(widgetInstanceManager, LOCAL_PAYMENTS_CONFIGURATION_DISABLED,
                    NotificationEvent.Level.INFO);
        }
        return super.performSave(widgetInstanceManager, currentObject);
    }

    @Override
    public void beforeEditorAreaRender(WidgetInstanceManager widgetInstanceManager, Object currentObject) {
        LocalPaymentsConfigurationModel localPaymentsConfigurationModel = (LocalPaymentsConfigurationModel) currentObject;
        if (!localPaymentsConfigurationModel.isEnable()) {
            notificationService.notifyUser(widgetInstanceManager, LOCAL_PAYMENTS_CONFIGURATION_DISABLED,
                    NotificationEvent.Level.WARNING);
        }
        super.beforeEditorAreaRender(widgetInstanceManager, currentObject);
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }
}
