package com.paypal.hybris.backoffice.handlers;

import com.hybris.backoffice.editorarea.BackofficeEditorAreaLogicHandler;
import com.hybris.backoffice.widgets.notificationarea.event.NotificationEvent;
import com.hybris.cockpitng.dataaccess.facades.object.exceptions.ObjectSavingException;
import com.hybris.cockpitng.engine.WidgetInstanceManager;
import com.hybris.cockpitng.util.notifications.NotificationService;
import com.paypal.hybris.core.model.HostedFieldsConfigurationModel;

public class HostedFieldsConfigurationEditorAreaLogicHandler extends BackofficeEditorAreaLogicHandler {

    private static final String HOSTED_FIELDS_CONFIGURATION_DISABLED = "hostedFieldsConfigurationDisabled";

    private NotificationService notificationService;

    @Override
    public Object performSave(WidgetInstanceManager widgetInstanceManager, Object currentObject) throws ObjectSavingException {
        HostedFieldsConfigurationModel hostedFieldsConfigurationModel = (HostedFieldsConfigurationModel) currentObject;
        if (!hostedFieldsConfigurationModel.isEnable()) {
            notificationService.notifyUser(widgetInstanceManager, HOSTED_FIELDS_CONFIGURATION_DISABLED,
                    NotificationEvent.Level.INFO);
        }
        return super.performSave(widgetInstanceManager, currentObject);
    }

    @Override
    public void beforeEditorAreaRender(WidgetInstanceManager widgetInstanceManager, Object currentObject) {
        HostedFieldsConfigurationModel hostedFieldsConfigurationModel = (HostedFieldsConfigurationModel) currentObject;
        if (!hostedFieldsConfigurationModel.isEnable()) {
            notificationService.notifyUser(widgetInstanceManager, HOSTED_FIELDS_CONFIGURATION_DISABLED,
                    NotificationEvent.Level.WARNING);
        }
        super.beforeEditorAreaRender(widgetInstanceManager, currentObject);
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }
}
