package com.paypal.hybris.backoffice.handlers;

import com.hybris.backoffice.editorarea.BackofficeEditorAreaLogicHandler;
import com.hybris.backoffice.widgets.notificationarea.event.NotificationEvent;
import com.hybris.cockpitng.dataaccess.facades.object.exceptions.ObjectSavingException;
import com.hybris.cockpitng.engine.WidgetInstanceManager;
import com.hybris.cockpitng.util.notifications.NotificationService;
import com.paypal.hybris.core.model.ConnectWithPayPalConfigurationModel;

public class ConnectWithPayPalConfigurationEditorAreaLogicHandler extends BackofficeEditorAreaLogicHandler {

    private static final String CONNECT_WITH_PAY_PAL_CONFIGURATION_DISABLED = "connectWithPayPalConfigurationDisabled";

    private NotificationService notificationService;

    @Override
    public Object performSave(WidgetInstanceManager widgetInstanceManager, Object currentObject) throws ObjectSavingException {
        ConnectWithPayPalConfigurationModel connectWithPayPalConfigurationModel = (ConnectWithPayPalConfigurationModel) currentObject;
        if (!connectWithPayPalConfigurationModel.isEnable()) {
            notificationService.notifyUser(widgetInstanceManager, CONNECT_WITH_PAY_PAL_CONFIGURATION_DISABLED,
                    NotificationEvent.Level.INFO);
        }
        return super.performSave(widgetInstanceManager, currentObject);
    }

    @Override
    public void beforeEditorAreaRender(WidgetInstanceManager widgetInstanceManager, Object currentObject) {
        ConnectWithPayPalConfigurationModel connectWithPayPalConfigurationModel = (ConnectWithPayPalConfigurationModel) currentObject;
        if (!connectWithPayPalConfigurationModel.isEnable()) {
            notificationService.notifyUser(widgetInstanceManager, CONNECT_WITH_PAY_PAL_CONFIGURATION_DISABLED,
                    NotificationEvent.Level.WARNING);
        }
        super.beforeEditorAreaRender(widgetInstanceManager, currentObject);
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }
}
