package com.paypal.hybris.backoffice.handlers;

import com.hybris.backoffice.editorarea.BackofficeEditorAreaLogicHandler;
import com.hybris.backoffice.widgets.notificationarea.event.NotificationEvent;
import com.hybris.cockpitng.dataaccess.facades.object.exceptions.ObjectSavingException;
import com.hybris.cockpitng.engine.WidgetInstanceManager;
import com.hybris.cockpitng.util.notifications.NotificationService;
import com.paypal.hybris.core.model.ApplePayConfigurationModel;

public class ApplePayConfigurationEditorAreaLogicHandler extends BackofficeEditorAreaLogicHandler {

    private static final String APPLE_PAY_CONFIGURATION_DISABLED = "applePayConfigurationDisabled";

    private NotificationService notificationService;

    @Override
    public Object performSave(WidgetInstanceManager widgetInstanceManager, Object currentObject) throws ObjectSavingException {
        ApplePayConfigurationModel applePayConfigurationModel = (ApplePayConfigurationModel) currentObject;
        if (!applePayConfigurationModel.isEnable()) {
            notificationService.notifyUser(widgetInstanceManager, APPLE_PAY_CONFIGURATION_DISABLED,
                    NotificationEvent.Level.INFO);
        }
        return super.performSave(widgetInstanceManager, currentObject);
    }

    @Override
    public void beforeEditorAreaRender(WidgetInstanceManager widgetInstanceManager, Object currentObject) {
        ApplePayConfigurationModel applePayConfigurationModel = (ApplePayConfigurationModel) currentObject;
        if (!applePayConfigurationModel.isEnable()) {
            notificationService.notifyUser(widgetInstanceManager, APPLE_PAY_CONFIGURATION_DISABLED,
                    NotificationEvent.Level.WARNING);
        }
        super.beforeEditorAreaRender(widgetInstanceManager, currentObject);
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }
}
