package com.paypal.hybris.backoffice.editors.paypalconfiguration;

import com.hybris.cockpitng.editor.defaultenum.DefaultEnumEditor;
import com.hybris.cockpitng.editors.EditorContext;
import com.hybris.cockpitng.editors.EditorListener;
import com.paypal.hybris.core.model.PayPalConfigurationModel;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ext.Disable;

public class PayPalConfigurationSavedPayPalAccountsLimitEditor extends DefaultEnumEditor {

    private static final String PARENT_OBJECT = "parentObject";

    @Override
    public void render(Component parent, EditorContext<Object> context, EditorListener<Object> listener) {
        preRender(parent, context, listener);
        PayPalConfigurationModel payPalConfigurationModel = (PayPalConfigurationModel) context.getParameter(PARENT_OBJECT);
        if (!payPalConfigurationModel.isPayPalEnable() || !payPalConfigurationModel.isVaultEnabled()) {
            Disable disable = (Disable) parent.getFirstChild();
            disable.setDisabled(true);
        }
    }

    protected void preRender(Component parent, EditorContext<Object> context, EditorListener<Object> listener) {
        super.render(parent, context, listener);
    }
}
