package com.paypal.hybris.backoffice.editors.paypalconfiguration;

import com.hybris.cockpitng.editor.localized.LocalizedEditor;
import com.hybris.cockpitng.editors.EditorContext;
import com.hybris.cockpitng.editors.EditorListener;
import com.hybris.cockpitng.util.UITools;
import com.paypal.hybris.core.model.PayPalConfigurationModel;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zul.Div;

public class PayPalConfigurationLocalizedStringEditor extends LocalizedEditor {

    private static final String DISABLED_DIV = "disabled-div";

    private static final String PARENT_OBJECT = "parentObject";

    @Override
    public void render(Component parent, EditorContext editorContext, EditorListener editorListener) {
        preRender(parent, editorContext, editorListener);
        PayPalConfigurationModel payPalConfigurationModel = (PayPalConfigurationModel) editorContext.getParameter(PARENT_OBJECT);
        if (!payPalConfigurationModel.isPayPalEnable()) {
            Div div = (Div) parent.getFirstChild();
            setDisabled(div);
        }
    }

    private void setDisabled(Div div) {
        UITools.modifySClass((HtmlBasedComponent) div.getChildren().get(0).getChildren().get(1), DISABLED_DIV, true);
        UITools.modifySClass((HtmlBasedComponent) div.getChildren().get(1), DISABLED_DIV, true);
    }

    protected void preRender(Component parent, EditorContext context, EditorListener listener) {
        super.render(parent, context, listener);
    }
}
