package com.paypal.hybris.backoffice.editors.localpaymentsconfiguration;

import com.hybris.cockpitng.editor.enummultireferenceeditor.DefaultEnumMultiReferenceEditor;
import com.hybris.cockpitng.editors.EditorContext;
import com.hybris.cockpitng.editors.EditorListener;
import com.hybris.cockpitng.util.UITools;
import com.paypal.hybris.core.enums.LocalPaymentFunding;
import com.paypal.hybris.core.model.LocalPaymentsConfigurationModel;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zul.Div;

import java.util.Collection;

public class LocalPaymentsConfigurationEnumListEditor extends DefaultEnumMultiReferenceEditor<LocalPaymentFunding> {

    private static final String DISABLED_DIV = "disabled-div";

    private static final String PARENT_OBJECT = "parentObject";

    @Override
    public void render(Component parent, EditorContext<Collection<LocalPaymentFunding>> context, EditorListener<Collection<LocalPaymentFunding>> listener) {
        preRender(parent, context, listener);
        LocalPaymentsConfigurationModel localPaymentsConfigurationModel = (LocalPaymentsConfigurationModel) context.getParameter(PARENT_OBJECT);
        if (!localPaymentsConfigurationModel.isEnable()) {
            Div div = (Div) parent.getFirstChild();
            setDisabled(div);
        }
    }

    private void setDisabled(Div div) {
        div.getChildren().forEach(component -> UITools.modifySClass((HtmlBasedComponent) component, DISABLED_DIV, true));
    }

    protected void preRender(Component parent, EditorContext<Collection<LocalPaymentFunding>> context, EditorListener<Collection<LocalPaymentFunding>> listener) {
        super.render(parent, context, listener);
    }
}
