package com.paypal.hybris.backoffice.editors.hostedfieldsconfigutation;

import com.hybris.cockpitng.editor.defaultenum.DefaultEnumEditor;
import com.hybris.cockpitng.editors.EditorContext;
import com.hybris.cockpitng.editors.EditorListener;
import com.paypal.hybris.core.model.HostedFieldsConfigurationModel;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ext.Disable;

public class HostedFieldsConfigurationSavedCreditCardsLimitEditor extends DefaultEnumEditor {

    private static final String PARENT_OBJECT = "parentObject";

    @Override
    public void render(Component parent, EditorContext<Object> context, EditorListener<Object> listener) {
        preRender(parent, context, listener);
        HostedFieldsConfigurationModel hostedFieldsConfigurationModel = (HostedFieldsConfigurationModel) context.getParameter(PARENT_OBJECT);
        if (!hostedFieldsConfigurationModel.isEnable() || !hostedFieldsConfigurationModel.isVaultFlow()) {
            Disable disable = (Disable) parent.getFirstChild();
            disable.setDisabled(true);
        }
    }

    protected void preRender(Component parent, EditorContext<Object> context, EditorListener<Object> listener) {
        super.render(parent, context, listener);
    }
}
