package com.paypal.hybris.backoffice.editors.hostedfieldsconfigutation;

import com.hybris.cockpitng.editor.defaultinteger.DefaultIntegerEditor;
import com.hybris.cockpitng.editors.EditorContext;
import com.hybris.cockpitng.editors.EditorListener;
import com.paypal.hybris.core.model.HostedFieldsConfigurationModel;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ext.Disable;

public class HostedFieldsConfigurationIntegerEditor extends DefaultIntegerEditor {

    private static final String PARENT_OBJECT = "parentObject";

    @Override
    public void render(Component parent, EditorContext<Integer> context, EditorListener<Integer> listener) {
        preRender(parent, context, listener);
        HostedFieldsConfigurationModel hostedFieldsConfigurationModel = (HostedFieldsConfigurationModel) context.getParameter(PARENT_OBJECT);
        if (!hostedFieldsConfigurationModel.isEnable()) {
            Disable disable = (Disable) parent.getFirstChild();
            disable.setDisabled(true);
        }
    }

    protected void preRender(Component parent, EditorContext<Integer> context, EditorListener<Integer> listener) {
        super.render(parent, context, listener);
    }

}