package com.paypal.hybris.backoffice.editors.connectwithpaypalconfiguration;

import com.hybris.cockpitng.editor.bool.DefaultBooleanEditor;
import com.hybris.cockpitng.editors.EditorContext;
import com.hybris.cockpitng.editors.EditorListener;
import com.hybris.cockpitng.util.UITools;
import com.paypal.hybris.core.model.ConnectWithPayPalConfigurationModel;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zul.Div;
import org.zkoss.zul.Radiogroup;

public class ConnectWithPayPalConfigurationBooleanEditor extends DefaultBooleanEditor {

    private static final String DISABLED_DIV = "disabled-div";

    private static final String PARENT_OBJECT = "parentObject";

    @Override
    public void render(Component parent, EditorContext<Boolean> editorContext, EditorListener<Boolean> listener) {
        preRender(parent, editorContext, listener);
        ConnectWithPayPalConfigurationModel connectWithPayPalConfigurationModel = (ConnectWithPayPalConfigurationModel) editorContext.getParameter(PARENT_OBJECT);
        if  (!connectWithPayPalConfigurationModel.isEnable()){
            Radiogroup radiogroup =(Radiogroup) parent.getFirstChild();
            setDisabled((Div) radiogroup.getChildren().get(0));
        }
    }

    private void setDisabled(Div div) {
        UITools.modifySClass((HtmlBasedComponent) div, DISABLED_DIV, true);
    }

    protected void preRender(Component parent, EditorContext<Boolean> editorContext, EditorListener<Boolean> listener) {
        super.render(parent, editorContext, listener);
    }
}
