package com.paypal.hybris.backoffice.action.order.tracking;

import com.hybris.cockpitng.actions.ActionContext;
import com.hybris.cockpitng.actions.ActionResult;
import com.hybris.cockpitng.actions.CockpitAction;
import com.hybris.cockpitng.engine.impl.AbstractComponentWidgetAdapterAware;
import com.paypal.hybris.backoffice.util.PayPalBackofficeUtil;
import com.paypal.hybris.core.enums.PaymentStatusType;
import de.hybris.platform.core.enums.OrderStatus;
import de.hybris.platform.core.model.order.OrderModel;
import org.apache.commons.collections.CollectionUtils;

public class PayPalSendTrackingInfoAction extends AbstractComponentWidgetAdapterAware implements
        CockpitAction<OrderModel, OrderModel> {

    protected static final String SOCKET_OUT_CONTEXT = "paypalTrackingInfoContext";

    @Override
    public boolean canPerform(ActionContext<OrderModel> ctx) {
        final OrderModel orderModel = ctx.getData();
        return orderModel != null && isCapturedButNotRefunded(orderModel) && hasShippedConsignment(orderModel);
    }

    @Override
    public ActionResult<OrderModel> perform(ActionContext<OrderModel> actionContext) {
        final OrderModel orderModel = actionContext.getData();
        sendOutput(SOCKET_OUT_CONTEXT, orderModel);
        return new ActionResult<>(ActionResult.SUCCESS);
    }

    private static boolean hasShippedConsignment(OrderModel orderModel) {
        return CollectionUtils.isNotEmpty(orderModel.getConsignments())
                && orderModel.getConsignments()
                .stream()
                .anyMatch(PayPalBackofficeUtil::hasShippedNotTrackedConsignments);
    }

    private static boolean isCapturedButNotRefunded(OrderModel orderModel) {
        return OrderStatus.COMPLETED.equals(orderModel.getStatus())
                && !PaymentStatusType.REFUNDED.equals(orderModel.getPaymentStatusType());
    }

}
