package com.paypal.hybris.backoffice.action.order.reauthorize;

import com.hybris.backoffice.widgets.notificationarea.NotificationService;
import com.hybris.cockpitng.actions.ActionContext;
import com.hybris.cockpitng.actions.ActionResult;
import com.hybris.cockpitng.actions.CockpitAction;
import com.hybris.cockpitng.engine.impl.AbstractComponentWidgetAdapterAware;
import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import de.hybris.platform.core.enums.OrderStatus;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.core.model.order.payment.PaymentInfoModel;
import de.hybris.platform.processengine.BusinessProcessService;
import de.hybris.platform.servicelayer.model.ModelService;
import org.apache.log4j.Logger;

import javax.annotation.Resource;
import java.util.Date;
import java.util.concurrent.TimeUnit;


public class PayPalReauthorizeAction extends AbstractComponentWidgetAdapterAware implements
    CockpitAction<OrderModel, OrderModel> {

    private static final Logger LOG = Logger.getLogger(PayPalReauthorizeAction.class);
    private static final String MANUAL_PAYMENT_REAUTH_EVENT = "ManualPaymentReauthEvent";
    private static final String SOCKET_OUT_CONTEXT = "paypalReauthorizeContext";
    private static final int MIN_DAYS = 4;
    private static final int MAX_DAYS = 29;
    @Resource
    private BusinessProcessService businessProcessService;
    @Resource
    private ModelService modelService;
    @Resource
    private NotificationService notificationService;

    public PayPalReauthorizeAction() {
        //default constructor
    }

    public ActionResult<OrderModel> perform(ActionContext<OrderModel> actionContext) {
        OrderModel order = actionContext.getData();

        sendOutput(SOCKET_OUT_CONTEXT, order);

        ActionResult<OrderModel> actionResult = new ActionResult<>(ActionResult.SUCCESS);
        executeManualPaymentAuthOperation(order);
        return actionResult;
    }

    public boolean canPerform(ActionContext<OrderModel> ctx) {
        boolean canPerform = false;
        OrderModel order = ctx.getData();
        if (order != null && !order.isAlreadyReauthorized()) {
                PaymentInfoModel paymentInfo = order.getPaymentInfo();
                canPerform = paymentInfo instanceof PayPalCreditCardPaymentInfoModel ?
                        !((PayPalCreditCardPaymentInfoModel) paymentInfo).isSaveOrderFlowActive()
                                && OrderStatus.PAYMENT_NOT_CAPTURED.equals(order.getStatus())
                                && isOrderApplicableForReauthorization(order.getDate()):
                        OrderStatus.PAYMENT_NOT_CAPTURED.equals(order.getStatus());
        }
        return canPerform;
    }

    public boolean needsConfirmation(ActionContext<OrderModel> ctx) {
        return false;
    }

    public String getConfirmationMessage(ActionContext<OrderModel> ctx) {
        return null;
    }

    public boolean isOrderApplicableForReauthorization(Date createdOrderDate) {
        Date currentDate = new Date();
        long diffInMilliseconds = Math.abs(currentDate.getTime() - createdOrderDate.getTime());
        long diffInDays = TimeUnit.DAYS.convert(diffInMilliseconds, TimeUnit.MILLISECONDS);
        return (diffInDays >= MIN_DAYS && diffInDays < MAX_DAYS);
    }

    protected void executeManualPaymentAuthOperation(OrderModel order) {
        order.getOrderProcess().stream()
            .filter(process -> process.getCode().startsWith(order.getStore().getSubmitOrderProcessCode()))
            .forEach(filteredProcess ->
                this.businessProcessService
                    .triggerEvent(filteredProcess.getCode() + "_" + MANUAL_PAYMENT_REAUTH_EVENT));
        LOG.info(String.format("Payment Reauth Manual Release completed. %s triggered.", MANUAL_PAYMENT_REAUTH_EVENT));
    }
}
